#include <stdio.h>

#include "issacapi_bs.h"

static int sample_setup() {
    ISSAC_RETURN result;

    result = ISSAC_Initialize();
    if (result != ISSAC_SUCCESS) {
        printf("[ERROR] %s\n", ISSAC_GetErrorMessage(result));
        return 1;
    }
    return 0;
}

static int sample_bs_base64() {
    ISSAC_RETURN result;
    // original is not string (not null terminated)
    const unsigned char original[] = { 'T','e','s','t' };
    char encoded[9] = { 0, };
    unsigned char decoded[4] = { 0, };
    int decodeSize = 0;

    printf("sample_bs_base64() => ");

    result = ISSAC_BASE64_Encode(encoded, sizeof(encoded), original, sizeof(original));
    if (result == ISSAC_SUCCESS) {
        result = ISSAC_BASE64_Decode(decoded, &decodeSize, sizeof(decoded), encoded);
    }

    if (result == ISSAC_SUCCESS) {
        printf("[OK]\n");
        return 0;
    } else {
        printf("[ERROR] %s\n", ISSAC_GetErrorMessage(result));
        return 1;
    }
}

int main() {
    int result;

    result = sample_setup();
    if (result != 0) {
        return result;
    }

    return sample_bs_base64();
}
