#include <stdio.h>

#include "issacapi_bs.h"

static const char *certB64 =
    "MIIFszCCBJugAwIBAgICAZkwDQYJKoZIhvcNAQELBQAwSzELMAkGA1UEBhMCS1IxEDAOBgNVBAoMB0lOSVBBU1MxFTATBgNVBAsMDEFjY3JlZGl0"
    "ZWRDQTETMBEGA1UEAwwKSU5JUEFTUyBDQTAeFw0xOTAzMTEwNTA0NTlaFw0xOTA2MDkxNDU5NTlaMIGCMQswCQYDVQQGEwJLUjEQMA4GA1UECgwH"
    "SU5JUEFTUzERMA8GA1UECwwIcGVyc29uYWwxFDASBgNVBAsMC0lOSVBBU1MyMDAwMTgwNgYDVQQDDC/snbTri4jthY3qsJzsnbgoSW5pUGVyKTIw"
    "MDA4MDEyMDE5MDMxMTkwMDAwMDAwMzCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAIrdG5fdGmTME6FpzwbFb5HBRojBKfbsSrpyiHlq"
    "n1uKBaaajoBsYIeNbOwg7roLkQvm0uodET4G3MWRJaAGGOtbIKffFd7nPo1oELinQvF2Gcr2siwgSI7YbvAnPI5s11Dc4D86NqS/b+tC/zSNuLUX"
    "bBKVoxUHG4E7IEEcK1zF5LLalvPFFwVhLx/IsylCvkHWw900jKGeBgBsFDklRDdSFI/jwiMnJgMtGYFxakXh6pMgzof4DQNCsA/8beHQ37iBXKoA"
    "380/tB3TFDJA2AB0KuOQDeFbvRLaiyqx7UNcWM6AM7ubcrj4B2XoS6zPTo85Dx6iQTaLPkwEQ6ilXDECAwEAAaOCAmcwggJjMIGPBgNVHSMEgYcw"
    "gYSAFKORisOXVoYiGgulHJtUsiz4oqcFoWikZjBkMQswCQYDVQQGEwJLUjENMAsGA1UECgwES0lTQTEuMCwGA1UECwwlS29yZWEgQ2VydGlmaWNh"
    "dGlvbiBBdXRob3JpdHkgQ2VudHJhbDEWMBQGA1UEAwwNS0lTQSBSb290Q0EgNIICECQwHQYDVR0OBBYEFFIslyxQUQ9/Bdlkw+0AiXaD150XMA4G"
    "A1UdDwEB/wQEAwIGwDB8BgNVHSABAf8EcjBwMG4GCiqDGoyaRAUFAQEwYDAuBggrBgEFBQcCARYiaHR0cDovL3d3dy5pbmlwYXNzLmNvbS9tYS9Q"
    "T18wNC5hZzAuBggrBgEFBQcCAjAiHiDHdAAgx3jJncEcspQAIKz1x3jHeMmdwRwAIMeFssiy5DBuBgNVHREEZzBloGMGCSqDGoyaRAoBAaBWMFQM"
    "D+ydtOuLiO2FjeqwnOyduDBBMD8GCiqDGoyaRAoBAQEwMTALBglghkgBZQMEAgGgIgQgeIkP8+qhOB5hQLxSg2CoENfDcrxKlJG9Fskt3RRSt4ow"
    "dwYDVR0fBHAwbjBsoGqgaIZmbGRhcDovL2Rpci5pbmlwYXNzLmNvbTozODkvb3U9ZHA4MXAxLG91PWNybGRwLG91PUFjY3JlZGl0ZWRDQSxvPUlO"
    "SVBBU1MsYz1rcj9jZXJ0aWZpY2F0ZVJldm9jYXRpb25MaXN0MDkGCCsGAQUFBwEBBC0wKzApBggrBgEFBQcwAYYdaHR0cDovL29jc3AuaW5pcGFz"
    "cy5jb206NDYxMi8wDQYJKoZIhvcNAQELBQADggEBADouu5wh+r1t0+elJZAScMwIBUNRcG/41aV6M9mjXVHTPj+874IeOqghlvVPdiRPGQl6RdXy"
    "E+QtVa2VM2yTgQjB0WP8iVRJmcHGj5oH2X1HV6Og0FhmgL+BNflrEzTuvu3FnYUgCynDGCNTl26beP2CVXUVcPiGasKSwxIoya8RtybzTQD1gZLv"
    "ZDEXqAGeYFKPNU+V4mTolDaB7+P+W98cGD47ai4efy0e4id8x6cl9eAMA7rCkshylxZnuPk6lOflR1SsRgAyzcT288yRuViEc/rKGGhrYz9fJGuS"
    "5Sz0PUTKzkxxn3/BPOhvRdgKSRBMX4ZGFqgiynj6qbZBqnQ=";
static unsigned char certBytes[4096] = { 0, };
static int certBytesLen = 0;

static int sample_setup() {
    ISSAC_RETURN result;

    result = ISSAC_Initialize();
    if (result != ISSAC_SUCCESS) {
        printf("[ERROR] %s\n", ISSAC_GetErrorMessage(result));
        return 1;
    }
    result = ISSAC_BASE64_Decode(certBytes, &certBytesLen, sizeof(certBytes), certB64);
    if (result != ISSAC_SUCCESS) {
        printf("[ERROR] %s\n", ISSAC_GetErrorMessage(result));
        return 1;
    }
    return 0;
}

static int sample_bs_cert() {
    ISSAC_RETURN result;
    CERTIFICATE cert;

    printf("sample_bs_cert() => ");

    ISSAC_CERTIFICATE_Create(&cert);

    //  б
    result = ISSAC_CERTIFICATE_Read_Memory(&cert, certBytes, certBytesLen);
    
    //  
    if (result == ISSAC_SUCCESS) {
        char subjectName[256] = { 0, };
        result = ISSAC_CERTIFICATE_GetSubjectName(subjectName, sizeof(subjectName), &cert);
    }

    ISSAC_CERTIFICATE_Delete(&cert);

    if (result == ISSAC_SUCCESS) {
        printf("[OK]\n");
        return 0;
    } else {
        printf("[ERROR] %s\n", ISSAC_GetErrorMessage(result));
        return 1;
    }
}

int main() {
    int result;

    result = sample_setup();
    if (result != 0) {
        return result;
    }

    return sample_bs_cert();
}
