#include <stdio.h>

#include "issacapi_bs.h"

/**
 * <pre>
 * ߱޴ : cn=׽Ʈ(-A),ou=RA,ou=TEST,ou=TEST߱޿,ou=licensedCA,o=KICA,c=KR
 * ߱ : cn=signGATE CA5,ou=AccreditedCA,o=KICA,c=KR
 * ȿⰣ : 2019/07/18 ~ 2020/07/19
 * Ű : RSA 2048
 *  ˰ : sha256WithRSAEncryption
 * </pre>
 */
static const char *certB64 =
    "MIIFcDCCBFigAwIBAgIEBOOmQDANBgkqhkiG9w0BAQsFADBKMQswCQYDVQQGEwJLUjENMAsGA1UECgwES0lDQTEVMBMGA1UECwwMQWNjcmVkaXRl"
    "ZENBMRUwEwYDVQQDDAxzaWduR0FURSBDQTUwHhcNMTkwNzE4MDEzODI4WhcNMjAwNzE5MTQ1OTU5WjCBkjELMAkGA1UEBhMCS1IxDTALBgNVBAoM"
    "BEtJQ0ExEzARBgNVBAsMCmxpY2Vuc2VkQ0ExFjAUBgNVBAsMDVRFU1TrsJzquInsmqkxFjAUBgNVBAsMDVRFU1Tsnbjspp3shJwxETAPBgNVBAsM"
    "CFJB7IS87YSwMRwwGgYDVQQDDBPthYzsiqTtirgo67KV7J24LUEpMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAs/0ZlxnYgA1RgfCR"
    "jUA+5A+2//k74rzNE2KTVD//ulxYViRnBGnPEBOegaP0ZEfhUm4T50utynUnmv6VTy4YC/yvLzbu+x4S1bsStluIUN6VJSfVW3jYHTvTadZeXHW7"
    "oQg6BtmMbRWX16PIwqxZ29fcO8NrQ+XFUAvVF22K3GLYdEga4l6W5iT2Jg0YUJZi1gozYAkd2bNeShyTOi+/mDQbPUr3zUfjYtmU+rEsjWWTUx9x"
    "+VLMC0oRsVIrAWHoj8Iyew07+OCgvQPoSgiEaFCcC4Pph75jNdlGERvTBDjraSerIqqp3d6gctXi5HtrDeT3ldm8sLshoNrQDL6yIwIDAQABo4IC"
    "EzCCAg8wgY8GA1UdIwSBhzCBhIAU2L467EWZxZ7jnOqBH9IdErA2PoihaKRmMGQxCzAJBgNVBAYTAktSMQ0wCwYDVQQKDARLSVNBMS4wLAYDVQQL"
    "DCVLb3JlYSBDZXJ0aWZpY2F0aW9uIEF1dGhvcml0eSBDZW50cmFsMRYwFAYDVQQDDA1LSVNBIFJvb3RDQSA0ggIQHTAdBgNVHQ4EFgQUnrcKqP2A"
    "ud+LdDCYTf3wDiCq4xAwDgYDVR0PAQH/BAQDAgUgMBcGA1UdIAQQMA4wDAYKKoMajJpEBQIBATCBiwYDVR0RBIGDMIGAgRVwdXJlMjcxM0BzaWdu"
    "Z2F0ZS5jb22gZwYJKoMajJpECgEBoFowWAwT7YWM7Iqk7Yq4KOuyleyduC1BKTBBMD8GCiqDGoyaRAoBAQEwMTALBglghkgBZQMEAgGgIgQgKitY"
    "vdm0gRTpVhMYPG+TQKIkVjffUR9NMEks9r0Q5IkwXwYDVR0fBFgwVjBUoFKgUIZObGRhcDovL2xkYXAuc2lnbmdhdGUuY29tOjM4OS9vdT1kcDdw"
    "MTUwMjksb3U9Y3JsZHAsb3U9QWNjcmVkaXRlZENBLG89S0lDQSxjPUtSMEQGCCsGAQUFBwEBBDgwNjA0BggrBgEFBQcwAYYoaHR0cDovL29jc3Au"
    "c2lnbmdhdGUuY29tOjkwMjAvT0NTUFNlcnZlcjANBgkqhkiG9w0BAQsFAAOCAQEAf9c0cN/64IYMApJkackYGuK+FZ0YzIHfksokUlEnuFerPVul"
    "X7jKyEhS9tU6Q4E+vsJwAQQtqI7IUHHqym6OPrY8gLvtzwmRVJRvdLMyRvhrdoseb3xaTA/gqYch/TtNk7qwYlO4b10DLUCVTK9wubbLscOZ3uFO"
    "XsrU6t1Lms9VnfVuZPFa+TH9LJ7pdLjbEGtSV+HZ+uNbdxfbTsgmDGux98E+MJqR7AsqnOICE/9W+lWPk3nNEKwWW7KA5SaRw38wgrJQDqoi7GlW"
    "pTbrYVv2M/IoSGMHipAEoPBzqU8nrnjiHVWatycNNGZGKQ8Jy7gAvbItl1xjjqIAsMQm3Q==";
static unsigned char certBytes[4096] = { 0, };
static int certBytesLen = 0;

/**
 * <pre>
 * ߱޴ : cn=signGATE CA5,ou=AccreditedCA,o=KICA,c=KR
 * ߱   : cn=KISA RootCA 4,ou=Korea Certification Authority Central,o=KISA,c=KR
 * ȿⰣ : 2015/12/29 ~ 2025/12/29
 * Ű   : RSA 2048
 *  ˰ : sha256WithRSAEncryption
 * </pre>
 */
static const char *crlIssuerB64 =
    "MIIGCzCCBPOgAwIBAgICEB0wDQYJKoZIhvcNAQELBQAwZDELMAkGA1UEBhMCS1IxDTALBgNVBAoMBEtJU0ExLjAsBgNVBAsMJUtvcmVhIENlcnRp"
    "ZmljYXRpb24gQXV0aG9yaXR5IENlbnRyYWwxFjAUBgNVBAMMDUtJU0EgUm9vdENBIDQwHhcNMTUxMjI5MDc0NjI1WhcNMjUxMjI5MDc0NjI1WjBK"
    "MQswCQYDVQQGEwJLUjENMAsGA1UECgwES0lDQTEVMBMGA1UECwwMQWNjcmVkaXRlZENBMRUwEwYDVQQDDAxzaWduR0FURSBDQTUwggEiMA0GCSqG"
    "SIb3DQEBAQUAA4IBDwAwggEKAoIBAQCpiTEmAeOssny+ettRSdHJWXBkRgE+nUOe19z0HUuy1L6G7iUVyMhc7GSqJFkZtcDWqLx3cKkBe5Vd7Xxb"
    "8fr52tXI+sQBnOQkb+tpfj6RNisbJAkTAGukOTkaiTuhL0s+AhdCNdkknF4i7aa53/NFD1XeOYVjnNwx2yz0gCY7jBb79UE6wB5h9qFyuHleiJCd"
    "lkNAeJIhe0cPWuakgj5kB1hpb7nW3lpiiSSDA99cG5x2oSlNzMfxX382CjsgvQclUp/Wz7kNl46fgrERTOsHN2N5A7nqxx8ipAfYyyy+lCnv9YE7"
    "xg13+5uzN0oRJCU1A7obMGRx5WwYeKMxXfTbAgMBAAGjggLfMIIC2zCBjgYDVR0jBIGGMIGDgBTI0I7HSa4fIEKyS38TyXdYDKHNwaFopGYwZDEL"
    "MAkGA1UEBhMCS1IxDTALBgNVBAoMBEtJU0ExLjAsBgNVBAsMJUtvcmVhIENlcnRpZmljYXRpb24gQXV0aG9yaXR5IENlbnRyYWwxFjAUBgNVBAMM"
    "DUtJU0EgUm9vdENBIDSCAQEwHQYDVR0OBBYEFNi+OuxFmcWe45zqgR/SHRKwNj6IMA4GA1UdDwEB/wQEAwIBBjCCATEGA1UdIAEB/wSCASUwggEh"
    "MIIBHQYEVR0gADCCARMwMAYIKwYBBQUHAgEWJGh0dHA6Ly93d3cucm9vdGNhLm9yLmtyL3JjYS9jcHMuaHRtbDCB3gYIKwYBBQUHAgIwgdEegc7H"
    "dAAgx3jJncEcspQAIKz1x3jHeMmdwRzHhbLIsuQAKABUAGgAaQBzACAAYwBlAHIAdABpAGYAaQBjAGEAdABlACAAaQBzACAAYQBjAGMAcgBlAGQA"
    "aQB0AGUAZAAgAHUAbgBkAGUAcgAgAEUAbABlAGMAdAByAG8AbgBpAGMAIABTAGkAZwBuAGEAdAB1AHIAZQAgAEEAYwB0ACAAbwBmACAAdABoAGUA"
    "IABSAGUAcAB1AGIAbABpAGMAIABvAGYAIABLAG8AcgBlAGEAKTAuBgNVHREEJzAloCMGCSqDGoyaRAoBAaAWMBQMEu2VnOq1reygleuztOyduOym"
    "nTASBgNVHRMBAf8ECDAGAQH/AgEAMA8GA1UdJAEB/wQFMAOAAQAwgY4GA1UdHwSBhjCBgzCBgKB+oHyGemxkYXA6Ly9sZGFwLnNpZ25nYXRlLmNv"
    "bTozODkvQ049S0lTQS1Sb290Q0EtNCxPVT1Lb3JlYS1DZXJ0aWZpY2F0aW9uLUF1dGhvcml0eS1DZW50cmFsLE89S0lTQSxDPUtSP2F1dGhvcml0"
    "eVJldm9jYXRpb25MaXN0MA0GCSqGSIb3DQEBCwUAA4IBAQAjR/p1dqrwXm2xAwNUHukCvVKRrkIo0ReXWUXBawmFM7JDVYdiOWho87z427OCToFJ"
    "jDxqw/iLQHMtIjfqpET2hRNIIFRsFKAnJEAhdboEf/zQ/++sAQBv/YRQLL0rxBVnq6ZGzCRsgAzLqc8d4wIC9bEQkPMNG5rFE3T36If82BZ7fDYV"
    "envihwoEi/3khfT1nX46YnmHMybEx+5bnFsxnQdNiDV3DHuVKLR8DqsXJwMVLWOJcD+7UqRaTYx/dJsTg/RUKiIjlSlA6lnsfp+mGhQ5iW+jA96I"
    "8dGjlXLhtbFpQyyQ0VxoXRm7eb+MibHY761l+/Sg/GsciJBATsBK";
static unsigned char crlIssuerBytes[4096] = { 0, };
static int crlIssuerBytesLen = 0;

static int sample_setup() {
    ISSAC_RETURN result;

    result = ISSAC_Initialize();
    if (result != ISSAC_SUCCESS) {
        printf("[ERROR] %s\n", ISSAC_GetErrorMessage(result));
        return 1;
    }
    result = ISSAC_BASE64_Decode(certBytes, &certBytesLen, sizeof(certBytes), certB64);
    if (result != ISSAC_SUCCESS) {
        printf("[ERROR] %s\n", ISSAC_GetErrorMessage(result));
        return 1;
    }
    result = ISSAC_BASE64_Decode(crlIssuerBytes, &crlIssuerBytesLen, sizeof(crlIssuerBytes), crlIssuerB64);
    if (result != ISSAC_SUCCESS) {
        printf("[ERROR] %s\n", ISSAC_GetErrorMessage(result));
        return 1;
    }
    return 0;
}

static int sample_bs_crl() {
    ISSAC_RETURN result;
    CERTIFICATE cert;
    CERTIFICATE crlIssuer;
    CERTIFICATEREVLIST crl;

    printf("sample_bs_crl() => ");

    ISSAC_CERTIFICATE_Create(&cert);
    ISSAC_CERTIFICATE_Create(&crlIssuer);
    ISSAC_CERTIFICATEREVLIST_Create(&crl);

    //  б
    result = ISSAC_CERTIFICATE_Read_Memory(&cert, certBytes, certBytesLen);
    // CRL ߱  б ( ߱ڿ )
    if (result == ISSAC_SUCCESS) {
        result = ISSAC_CERTIFICATE_Read_Memory(&crlIssuer, crlIssuerBytes, crlIssuerBytesLen);
    }
    //  CDP ̿Ͽ CRL ޱ
    if (result == ISSAC_SUCCESS) {
        result = ISSAC_DL_ReadCDPCERTIFICATEREVLIST_Timeout(&crl, &cert, NULL, 4);
    }
    // CRL ߱ڰ ´ Ȯϱ
    if (result == ISSAC_SUCCESS) {
        result = ISSAC_CERTIFICATEREVLIST_Verify(&crl, &crlIssuer);
    }
    // CRL ȿⰣ Ȯϱ (0 : ð)
    if (result == ISSAC_SUCCESS) {
        result = ISSAC_CERTIFICATEREVLIST_ValidAt(&crl, 0);
    }
    // CRL Ȱ (ex. sample_usr_path_validation_ex.c)

    ISSAC_CERTIFICATE_Delete(&cert);
    ISSAC_CERTIFICATE_Delete(&crlIssuer);
    ISSAC_CERTIFICATEREVLIST_Delete(&crl);

    if (result == ISSAC_SUCCESS) {
        printf("[OK]\n");
        return 0;
    } else {
        printf("[ERROR] %s\n", ISSAC_GetErrorMessage(result));
        return 1;
    }
}

int main() {
    int result;

    result = sample_setup();
    if (result != 0) {
        return result;
    }

    return sample_bs_crl();
}
