#include <stdio.h>

#include "issacapi_bs.h"
#include "issacapi_errorcode.h"

/**
 * <pre>
 *  : cn=KISA RootCA 4,ou=Korea Certification Authority Central,o=KISA,c=KR
 * Ե  ؽð 
 *   - 407C276BEAD2E4AF0661EF6697341DEC0A1F9434E4EAFB2D3D32A90549D9DE4A
 *     - cn=GPKIRootCA1,ou=GPKI,o=Government of Korea,c=KR
 *   - 4A072CFA8B4F0AC060C0DB6D31EBF32475DAA27D55773CD76D0F0ED5CF8F1BA4
 *     - cn=GPKIRootCA,ou=GPKI,o=Government of Korea,c=KR
 *   - 6FDB3F76C8B801A75338D8A50A7C02879F6198B57E594D318D3832900FEDCD79
 *     - cn=KISA RootCA 1,ou=Korea Certification Authority Central,o=KISA,c=KR
 *   - E5C01CB4093279FAA19FCFA24EA43EB1B26D07A615ADF7240184A1E716B761C9
 *     - cn=Root CA,ou=GPKI,o=Government of Korea,c=KR
 * Ե  
 *   -  ؽð شϴ   
 * ȿⰣ : 2019/12/13 ~ 2019/12/27
 * </pre>
 */
static const char *ctlB64 =
    "MIIUigYJKoZIhvcNAQcCoIIUezCCFHcCAQExDTALBglghkgBZQMEAgEwgeEGCSsGAQQBgjcKAaCB0zCB0DAMBgoqgxqMmkQIAQEBAgIBpRcNMTkx"
    "MjEzMDIxMTU2WhcNMTkxMjI3MDIxMTU2WjALBglghkgBZQMEAgEwgZAwIgQgQHwna+rS5K8GYe9mlzQd7AoflDTk6vstPTKpBUnZ3kowIgQgSgcs"
    "+otPCsBgwNttMevzJHXaon1VdzzXbQ8O1c+PG6QwIgQgb9s/dsi4AadTONilCnwCh59hmLV+WU0xjTgykA/tzXkwIgQg5cActAkyefqhn8+iTqQ+"
    "sbJtB6YVrfckAYSh5xa3YcmgghF8MIIDXTCCAkWgAwIBAgIBATANBgkqhkiG9w0BAQsFADBQMQswCQYDVQQGEwJLUjEcMBoGA1UECgwTR292ZXJu"
    "bWVudCBvZiBLb3JlYTENMAsGA1UECwwER1BLSTEUMBIGA1UEAwwLR1BLSVJvb3RDQTEwHhcNMTEwODAzMDY1MjMwWhcNMzEwODAzMDY1MjMwWjBQ"
    "MQswCQYDVQQGEwJLUjEcMBoGA1UECgwTR292ZXJubWVudCBvZiBLb3JlYTENMAsGA1UECwwER1BLSTEUMBIGA1UEAwwLR1BLSVJvb3RDQTEwggEi"
    "MA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQCh/m8EBbDJhGQyN2+g5dTlsgjtaRKqhgj3gkYKBgtuXsXkaTVxbf99AvbN3QE8+WCIaPJUd009"
    "1UGmLzaBVyW4ct+iUNrX/FXyzjafbNbbl1nfHhaZhkiOTVQhmY5zuj96evEtJMevnxe6iRADOPWnqp+CxT2IzcSFkQCq7L2qn8hU2/LpXUvnAYgl"
    "JZi8t6Ef+r03P1r8dA5OzZ8yV3qhD1R1wsNQtCzMgwcErFRZhFZYuxpfmS5y0fZW0seeTjcdxHiR3whYI5U6AI7DjdWIrT9Cd9ByV4aevkBhqkeP"
    "PIYGmUPXnnqCkdHdnzkMH0WP9TBhD2jTXZKdcFtTyEJrAgMBAAGjQjBAMB0GA1UdDgQWBBR4A+sMjKbTVXWkh7Tr0ZpmD0xzizAOBgNVHQ8BAf8E"
    "BAMCAQYwDwYDVR0TAQH/BAUwAwEB/zANBgkqhkiG9w0BAQsFAAOCAQEARGJWATwo81x7UEQugNbicL8IWXoV51SZVH3kz49fNUjVoq1n2yzfaMdd"
    "lblbflDNObp/68DxTlSXCeqFHkgi/WvyVHERRECXnF0WeeelI+Q8XdF3IJZLT3u5Ss0VAB2loCuC+4hBWSRQu2WZu2Yks9eBN0x6NmtopRmnf2d6"
    "VrcFA+WOgUeTjXiDkG52IaPw0w1uTfmRw5epky5idyY2bfJ1JeVUINMJnOWpgLkOH3xxakoD8F1Fbi6C3t7MmKupojUq/toUDms6zTk3DIkcwd7P"
    "ALNWL5U8TxNLoroTHSf/lzaOv3o9KDRa0FQo58bPI7MdbRWE4F3mS/ZIrnv7jTCCA4owggJyoAMCAQICEEhHkgkDTLZvEAVSVlBFi3swDQYJKoZI"
    "hvcNAQEFBQAwTzELMAkGA1UEBhMCS1IxHDAaBgNVBAoME0dvdmVybm1lbnQgb2YgS29yZWExDTALBgNVBAsMBEdQS0kxEzARBgNVBAMMCkdQS0lS"
    "b290Q0EwHhcNMDgwNjA1MDcxMzEzWhcNMjgwNjA1MDcxMzEzWjBPMQswCQYDVQQGEwJLUjEcMBoGA1UECgwTR292ZXJubWVudCBvZiBLb3JlYTEN"
    "MAsGA1UECwwER1BLSTETMBEGA1UEAwwKR1BLSVJvb3RDQTCCASEwDQYJKoZIhvcNAQEBBQADggEOADCCAQkCggEAWitBFZvbdiYB8FRyC4cTH6DQ"
    "P5aqDbM0gd5IWp/zcFrC8TqeBPBOlHmX4fS1FEzXb8SLGLfcEisdCpvuIAxbj//5r4KemEbQPV0o85cWwVzlVr9EpAChesubelvc1O378qACZwAe"
    "ROWKAdylo07+1gxnykm58NCg+U0fA9OG7w2FdU3z7fvNamYEV/RXm6xmik/CqE9xiQndTADflrvVkAq0tmptxr/TmSn/YvAQ2kWsCXILghDoFaiL"
    "X+KiWnkewmf96URXCwPQIRVRsADzj23iI/BJIdltz2I97Ov9KJIBP3qjcnzr867n+Arsbq16m1XJMEuctmFGa1ga/p9IHQIDAQABo2MwYTAfBgNV"
    "HSMEGDAWgBQWZzL0aF5oMUfb7ezOYS6aJEbEfTAdBgNVHQ4EFgQUFmcy9GheaDFH2+3szmEumiRGxH0wDgYDVR0PAQH/BAQDAgGuMA8GA1UdEwEB"
    "/wQFMAMBAf8wDQYJKoZIhvcNAQEFBQADggEBAAczpXMGX0GfAnyDlbilzNMHP4jKmhW8q4KMcoqTKS/JzXo0efdAMdikgaSGGw4j2O0qCmU3fN0t"
    "JoVCcEUCekaofVqfgBs3yhmqyiVM3sJ/nAfLkWBcEyhTSzmwhLyR31e9urGZlCVb9qqOITYyScKZi4JQpmhA8aiTCL+Qi3O84xkYbG+3lD17/L9p"
    "1o0wbBPkpSdRn2z/kcgcI1jaoKW3rZkqyWBEA/ztqBRim7qwmO6vDA/yAxKk4VkmfHDSF3N8Y3jZ2bsUJ4BwYDrsk7YdQrm4i3R6kVQERCNLe4Eq"
    "uZ8P5xg1n1EDqg41K7YI15XnP7Ebsn/f3ZhU7//Fr/YwggNzMIICW6ADAgECAgEEMA0GCSqGSIb3DQEBBQUAMGQxCzAJBgNVBAYTAktSMQ0wCwYD"
    "VQQKDARLSVNBMS4wLAYDVQQLDCVLb3JlYSBDZXJ0aWZpY2F0aW9uIEF1dGhvcml0eSBDZW50cmFsMRYwFAYDVQQDDA1LSVNBIFJvb3RDQSAxMB4X"
    "DTA1MDgyNDA4MDU0NloXDTI1MDgyNDA4MDU0NlowZDELMAkGA1UEBhMCS1IxDTALBgNVBAoMBEtJU0ExLjAsBgNVBAsMJUtvcmVhIENlcnRpZmlj"
    "YXRpb24gQXV0aG9yaXR5IENlbnRyYWwxFjAUBgNVBAMMDUtJU0EgUm9vdENBIDEwggEgMA0GCSqGSIb3DQEBAQUAA4IBDQAwggEIAoIBAQC8BOT6"
    "EznwNJYga2xou/rbd/8n96zsL+f98H9tb4wqzSUJWyT0oWj8KOzJJeKs7d7IM4T1sKUJOqexR0jFzE+MeZz5Bld93e449s8Uspzq08Bdd2LwRw25"
    "GkBTXGRwrwhawPfPdflsjWQoHiD+txsZ01pmg3LisJu90yUVDTJvZDeUhUbIcr531W4fKC/Hae3ng4kzWNPeoL9A6ENQ7txNa7yl6qbIYY71w2Sv"
    "BhXcKYs/dYy8cUTb/K21Fx1tiYPPxjO9v0Wi/gqfoxFfD7kfnBrCRsycKGafcCY8Lt+qgP6MxQQJJU/Nk0c8N+oCZ5L+/CIkXKzSLOBcATOKwRnb"
    "AgEDozIwMDAdBgNVHQ4EFgQUv7Yn2ANadmVMYQFBVjHli3s62cwwDwYDVR0TAQH/BAUwAwEB/zANBgkqhkiG9w0BAQUFAAOCAQEAE69RC96Kalvm"
    "mgrIsZBKTqECncyI0qtmvT3su7FClWqyXFr/oWNklqloFX8lXor4pHPBgIqFCg5S6DLnRfhOZYCRmXRD5UWdSSrwlJXd6eEw0hNuyU6xd+UEz61a"
    "HpQJWtc8CByueukUMsFFrdImSHKsqEHa8CGHOV7f/GT/YXQqnNmbi1/CN5PYozcvO5NrshsHp38JUO/TOr4ha4qQOydKUU5rnpyHnfh4kDHtESfG"
    "qFm+/BgL+45+LkLh7ecJIb25E8VWZ/QmpkJDkERUtHGbduQaEqwaKADfm8HV+Ntco/iSsb201PlQ2QACT9uD0BFPpEJWYTp+EzLThB/JujCCA5kw"
    "ggKBoAMCAQICEDzCgUsA51JNm6pHt+Fh9Q4wDQYJKoZIhvcNAQEFBQAwTDELMAkGA1UEBhMCS1IxHDAaBgNVBAoTE0dvdmVybm1lbnQgb2YgS29y"
    "ZWExDTALBgNVBAsTBEdQS0kxEDAOBgNVBAMTB1Jvb3QgQ0EwHhcNMDkxMjIzMTExMzI0WhcNMTQxMjIzMTExMzI0WjBMMQswCQYDVQQGEwJLUjEc"
    "MBoGA1UEChMTR292ZXJubWVudCBvZiBLb3JlYTENMAsGA1UECxMER1BLSTEQMA4GA1UEAxMHUm9vdCBDQTCCASEwDQYJKoZIhvcNAQEBBQADggEO"
    "ADCCAQkCggEAQNahQhcsVUDfmnrDkfTjvZEr9dtcZi+JXP141AlMPafEnC768Fm2vbTSjSgIq68TQa6AQvTrXC1ffkN6NbWvP9zEPTZFkrK4fg28"
    "rMfBZNjebc6zpI5Qfkj0rY7Zhhk1A4p3KHUtgltK7KXLcQL0RDGDSnnszmX/HKEzZq9bMmX+5q2HJ0z9TxgJmGR+P843VvPC4MaZmwBLN5jvHGMq"
    "la6tA886XCIOPdn1cHF2+0TPKwAhJnA64arrzUn7O2K4dFpWpfIskj61ALyEv2DjQm6No+Bktq2lQ5j3Yd/F6ODw1aa9oGlvcm6OjQ/L9vjr9sxb"
    "c53VLfHOF9veCH/cjQIDAQABo3gwdjAfBgNVHSMEGDAWgBQCE+6uHCA4LKnwb+pfnwc6k+9HdDAdBgNVHQ4EFgQUAhPurhwgOCyp8G/qX58HOpPv"
    "R3QwDgYDVR0PAQH/BAQDAgEGMBMGA1UdIAQMMAowCAYEVR0gADAAMA8GA1UdEwEB/wQFMAMBAf8wDQYJKoZIhvcNAQEFBQADggEBAEDFNgcY8LZt"
    "Z4nKt5a51qYGWNdN3UlinLBsoOjevYjxyCaVTBGTu0u8dm3svUM0+9dikLzjrRm8OI+cBnPYSwAQmafPCD6gM1Nfb+pttK7pTpnOTiqS1ZILdyW8"
    "VZV4roRdshLtTQ9qqVPZSddSuwmEHdLuVEbdoIgeqSjhvhf/fMrzM/LlQa93cBV9oMSBddEZqJ8ab6TSdnIfDkMbo7b2tXNe0pf9L/NWBKkTzBKn"
    "FtFtsiIM8QY1Y0WTyon6/R4JTye1VHcRBHMU3Omeuw+b4cIlU8TzN+HNLSYTILiMtu1xdl9Pwf8YG7OHwy+NC1LaxL2zRgWiqJEnzPgBpjIwggN1"
    "MIICXaADAgECAgEBMA0GCSqGSIb3DQEBCwUAMGQxCzAJBgNVBAYTAktSMQ0wCwYDVQQKDARLSVNBMS4wLAYDVQQLDCVLb3JlYSBDZXJ0aWZpY2F0"
    "aW9uIEF1dGhvcml0eSBDZW50cmFsMRYwFAYDVQQDDA1LSVNBIFJvb3RDQSA0MB4XDTEwMDcxMjA5MjYyMVoXDTMwMDcxMjA5MjYyMVowZDELMAkG"
    "A1UEBhMCS1IxDTALBgNVBAoMBEtJU0ExLjAsBgNVBAsMJUtvcmVhIENlcnRpZmljYXRpb24gQXV0aG9yaXR5IENlbnRyYWwxFjAUBgNVBAMMDUtJ"
    "U0EgUm9vdENBIDQwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQDF6k5iaJinEV27pIJJWAwKsCCzAttFJiD/7S1qH8KMgcyfYlrnTp+m"
    "zJ+HI3+lfid8QVeFCxW1NoY0CQH79x+s85q6m56HilvBlzspijiZpS0ru0OPcXqK7FpruPABZbb8UpjSNB8GRVX1X6N89UMmiQQUY2frfNiItwhA"
    "Fqg9xD+Ynw8pH6AYGGBQXEhYpC+L7lyuiKXNy74iCb+e/3e6p0FQKugGje21Oj4h9Qe6PXec47xVsAEZEDnck9XhXeINAEbdY+BJWNqT8BB/sw/w"
    "XsfIavjb+gUjwtv471bgxYYxqbJiSJ3EYF2txvrWpyNBCcM1atsWw6uYrAli/bwzAgMBAAGjMjAwMB0GA1UdDgQWBBTI0I7HSa4fIEKyS38TyXdY"
    "DKHNwTAPBgNVHRMBAf8EBTADAQH/MA0GCSqGSIb3DQEBCwUAA4IBAQCb8a4Myk9vzzoWTydNQdVobyBarwnA3aw41LzgitA6fQqozXNgZe5eG/wf"
    "Ycp4FqEspEFAp9ep+j1ZJ211MvDcDCjUQZVAOcxilo0wcjd+6UQnxkJbA8LO7gGwbnzeJicb7ng5q2OvkBRTS9kYw0GwxWRl/RoWD08InQ9IqD+I"
    "VBvjymsnQjLmTspeWUiKxA25mXKt4BN201TRqNhb1YdcVgL/BquPJ3ttLP0qZS4yNDfEDktbd2QLVAtr5EeCDmU2Uw0yv6yrf5wVjwudzExvL2Oo"
    "vtbHft+N2ptDmTCMdydIcV70Ae7oZJ3/jbl7YCkcVcNieHr6bRsaQ02uDz8ZMYIB/TCCAfkCAQEwaTBkMQswCQYDVQQGEwJLUjENMAsGA1UECgwE"
    "S0lTQTEuMCwGA1UECwwlS29yZWEgQ2VydGlmaWNhdGlvbiBBdXRob3JpdHkgQ2VudHJhbDEWMBQGA1UEAwwNS0lTQSBSb290Q0EgNAIBATALBglg"
    "hkgBZQMEAgGgaTAYBgkqhkiG9w0BCQMxCwYJKwYBBAGCNwoBMBwGCSqGSIb3DQEJBTEPFw0xOTEyMTMwMjExNTZaMC8GCSqGSIb3DQEJBDEiBCCp"
    "z9mohBS77pRwQ8jmrAnm2k8Vtz5MSj0aSvzslZANrzANBgkqhkiG9w0BAQEFAASCAQBPDHZjj5bC1N9Pzf28XEp9O5fNgYl3F0ece/WpjoHV5VmJ"
    "nBfvmqS0JJ+Rw0OR23DxPdYhz2Ntdwi0Q9k/P12l8xR4a/lorBNqg6hj8yzUIBxSanEBEOasLGZ8Lv4qDeM8UgThtlS7XnLevlhmLnKN/xxNK0NF"
    "f1sXv9v05ai2YTx8xxEDG7YDNawExKdSAlOo9+aUhOPMATzkML8YasbhBjAepkCXRnfNN7DogFrYDwL3IhX5Habv85tUODLTN4OOZiGVdZdi4PFe"
    "UXLN63Iu9kicLs06O0sR9Gfo/eJZvOgBTtfP5XYAM19QCCLedKdl9Gs+RZ2/rosgLIkZoXxp";
static unsigned char ctlBytes[8192] = { 0, };
static int ctlBytesLen = 0;

/**
 * <pre>
 * ߱޴ : cn=KISA RootCA 4,ou=Korea Certification Authority Central,o=KISA,c=KR
 * ߱   : cn=KISA RootCA 4,ou=Korea Certification Authority Central,o=KISA,c=KR
 * ȿⰣ : 2010/07/12 ~ 2030/07/12
 * Ű   : RSA 2048
 *  ˰ : sha256WithRSAEncryption
 * </pre>
 */
static const char *ctlIssuerB64 =
    "MIIDdTCCAl2gAwIBAgIBATANBgkqhkiG9w0BAQsFADBkMQswCQYDVQQGEwJLUjENMAsGA1UECgwES0lTQTEuMCwGA1UECwwlS29yZWEgQ2VydGlm"
    "aWNhdGlvbiBBdXRob3JpdHkgQ2VudHJhbDEWMBQGA1UEAwwNS0lTQSBSb290Q0EgNDAeFw0xMDA3MTIwOTI2MjFaFw0zMDA3MTIwOTI2MjFaMGQx"
    "CzAJBgNVBAYTAktSMQ0wCwYDVQQKDARLSVNBMS4wLAYDVQQLDCVLb3JlYSBDZXJ0aWZpY2F0aW9uIEF1dGhvcml0eSBDZW50cmFsMRYwFAYDVQQD"
    "DA1LSVNBIFJvb3RDQSA0MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAxepOYmiYpxFdu6SCSVgMCrAgswLbRSYg/+0tah/CjIHMn2Ja"
    "506fpsyfhyN/pX4nfEFXhQsVtTaGNAkB+/cfrPOaupueh4pbwZc7KYo4maUtK7tDj3F6iuxaa7jwAWW2/FKY0jQfBkVV9V+jfPVDJokEFGNn63zY"
    "iLcIQBaoPcQ/mJ8PKR+gGBhgUFxIWKQvi+5croilzcu+Igm/nv93uqdBUCroBo3ttTo+IfUHuj13nOO8VbABGRA53JPV4V3iDQBG3WPgSVjak/AQ"
    "f7MP8F7HyGr42/oFI8Lb+O9W4MWGMamyYkidxGBdrcb61qcjQQnDNWrbFsOrmKwJYv28MwIDAQABozIwMDAdBgNVHQ4EFgQUyNCOx0muHyBCskt/"
    "E8l3WAyhzcEwDwYDVR0TAQH/BAUwAwEB/zANBgkqhkiG9w0BAQsFAAOCAQEAm/GuDMpPb886Fk8nTUHVaG8gWq8JwN2sONS84IrQOn0KqM1zYGXu"
    "Xhv8H2HKeBahLKRBQKfXqfo9WSdtdTLw3Awo1EGVQDnMYpaNMHI3fulEJ8ZCWwPCzu4BsG583iYnG+54Oatjr5AUU0vZGMNBsMVkZf0aFg9PCJ0P"
    "SKg/iFQb48prJ0Iy5k7KXllIisQNuZlyreATdtNU0ajYW9WHXFYC/warjyd7bSz9KmUuMjQ3xA5LW3dkC1QLa+RHgg5lNlMNMr+sq3+cFY8LncxM"
    "by9jqL7Wx37fjdqbQ5kwjHcnSHFe9AHu6GSd/425e2ApHFXDYnh6+m0bGkNNrg8/GQ==";
static unsigned char ctlIssuerBytes[4096] = { 0, };
static int ctlIssuerBytesLen = 0;

/**
 * <pre>
 * ߱޴ : cn=GPKIRootCA1,ou=GPKI,o=Government of Korea,c=KR
 * ߱   : cn=GPKIRootCA1,ou=GPKI,o=Government of Korea,c=KR
 * ȿⰣ : 2011/08/03 ~ 2031/08/03
 * Ű   : RSA 2048
 *  ˰ : sha256WithRSAEncryption
 * </pre>
 */
static const char *otherRootCertB64 =
    "MIIDXTCCAkWgAwIBAgIBATANBgkqhkiG9w0BAQsFADBQMQswCQYDVQQGEwJLUjEcMBoGA1UECgwTR292ZXJubWVudCBvZiBLb3JlYTENMAsGA1UE"
    "CwwER1BLSTEUMBIGA1UEAwwLR1BLSVJvb3RDQTEwHhcNMTEwODAzMDY1MjMwWhcNMzEwODAzMDY1MjMwWjBQMQswCQYDVQQGEwJLUjEcMBoGA1UE"
    "CgwTR292ZXJubWVudCBvZiBLb3JlYTENMAsGA1UECwwER1BLSTEUMBIGA1UEAwwLR1BLSVJvb3RDQTEwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAw"
    "ggEKAoIBAQCh/m8EBbDJhGQyN2+g5dTlsgjtaRKqhgj3gkYKBgtuXsXkaTVxbf99AvbN3QE8+WCIaPJUd0091UGmLzaBVyW4ct+iUNrX/FXyzjaf"
    "bNbbl1nfHhaZhkiOTVQhmY5zuj96evEtJMevnxe6iRADOPWnqp+CxT2IzcSFkQCq7L2qn8hU2/LpXUvnAYglJZi8t6Ef+r03P1r8dA5OzZ8yV3qh"
    "D1R1wsNQtCzMgwcErFRZhFZYuxpfmS5y0fZW0seeTjcdxHiR3whYI5U6AI7DjdWIrT9Cd9ByV4aevkBhqkePPIYGmUPXnnqCkdHdnzkMH0WP9TBh"
    "D2jTXZKdcFtTyEJrAgMBAAGjQjBAMB0GA1UdDgQWBBR4A+sMjKbTVXWkh7Tr0ZpmD0xzizAOBgNVHQ8BAf8EBAMCAQYwDwYDVR0TAQH/BAUwAwEB"
    "/zANBgkqhkiG9w0BAQsFAAOCAQEARGJWATwo81x7UEQugNbicL8IWXoV51SZVH3kz49fNUjVoq1n2yzfaMddlblbflDNObp/68DxTlSXCeqFHkgi"
    "/WvyVHERRECXnF0WeeelI+Q8XdF3IJZLT3u5Ss0VAB2loCuC+4hBWSRQu2WZu2Yks9eBN0x6NmtopRmnf2d6VrcFA+WOgUeTjXiDkG52IaPw0w1u"
    "TfmRw5epky5idyY2bfJ1JeVUINMJnOWpgLkOH3xxakoD8F1Fbi6C3t7MmKupojUq/toUDms6zTk3DIkcwd7PALNWL5U8TxNLoroTHSf/lzaOv3o9"
    "KDRa0FQo58bPI7MdbRWE4F3mS/ZIrnv7jQ==";
static unsigned char otherRootCertBytes[4096] = { 0, };
static int otherRootCertBytesLen = 0;

static int sample_setup() {
    ISSAC_RETURN result;

    result = ISSAC_Initialize();
    if (result != ISSAC_SUCCESS) {
        printf("[ERROR] %s\n", ISSAC_GetErrorMessage(result));
        return 1;
    }
    result = ISSAC_BASE64_Decode(ctlBytes, &ctlBytesLen, sizeof(ctlBytes), ctlB64);
    if (result != ISSAC_SUCCESS) {
        printf("[ERROR] %s\n", ISSAC_GetErrorMessage(result));
        return 1;
    }
    result = ISSAC_BASE64_Decode(ctlIssuerBytes, &ctlIssuerBytesLen, sizeof(ctlIssuerBytes), ctlIssuerB64);
    if (result != ISSAC_SUCCESS) {
        printf("[ERROR] %s\n", ISSAC_GetErrorMessage(result));
        return 1;
    }
    result = ISSAC_BASE64_Decode(otherRootCertBytes, &otherRootCertBytesLen, sizeof(otherRootCertBytes), otherRootCertB64);
    if (result != ISSAC_SUCCESS) {
        printf("[ERROR] %s\n", ISSAC_GetErrorMessage(result));
        return 1;
    }
    return 0;
}

static int sample_bs_ctl() {
    ISSAC_RETURN result;
    CERTIFICATETRUSTLIST ctl;
    CERTIFICATE ctlIssuer;

    printf("sample_bs_ctl() => ");

    ISSAC_CERTIFICATETRUSTLIST_Create(&ctl);
    ISSAC_CERTIFICATE_Create(&ctlIssuer);

    // CTL б
    result = ISSAC_CERTIFICATETRUSTLIST_Read_Memory(&ctl, ctlBytes, ctlBytesLen);
    // CTL ߱  б
    if (result == ISSAC_SUCCESS) {
        result = ISSAC_CERTIFICATE_Read_Memory(&ctlIssuer, ctlIssuerBytes, ctlIssuerBytesLen);
    }
    // CTL ϱ (SignedData)
    if (result == ISSAC_SUCCESS) {
        result = ISSAC_CERTIFICATETRUSTLIST_Verify(&ctl, &ctlIssuer);
    }
    // CRL ȿⰣ Ȯϱ (0 : ð)
    //  - Note(jyha) :  CTL ȿⰣ ǾǷ Ȯ . (   Ȯ !)
    // if (result == ISSAC_SUCCESS) {
    //     result = ISSAC_CERTIFICATETRUSTLIST_ValidAt(&ctl, 0);
    // }
    // CTL Ȱ
    if (result == ISSAC_SUCCESS) {
        CERTIFICATE otherRootCert;
        ISSAC_CERTIFICATE_Create(&otherRootCert);
        // ٸ Root CA  б
        result = ISSAC_CERTIFICATE_Read_Memory(&otherRootCert, otherRootCertBytes, otherRootCertBytesLen);
        if (result == ISSAC_SUCCESS) {
            //  Root CA  CTL  ԵǾ ִ Ȯϱ
            result = ISSAC_CERTIFICATETRUSTLIST_IsCertificateTrusted(&ctl, &otherRootCert);
        }
        ISSAC_CERTIFICATE_Delete(&otherRootCert);
    }

    ISSAC_CERTIFICATETRUSTLIST_Delete(&ctl);
    ISSAC_CERTIFICATE_Delete(&ctlIssuer);

    if (result == ISSAC_SUCCESS) {
        printf("[OK]\n");
        return 0;
    } else {
        printf("[ERROR] %s\n", ISSAC_GetErrorMessage(result));
        return 1;
    }
}

int main() {
    int result;

    result = sample_setup();
    if (result != 0) {
        return result;
    }

    return sample_bs_ctl();
}
