#include <stdio.h>

#include "issacapi_dl.h"

static int sample_setup() {
    ISSAC_RETURN result;

    result = ISSAC_Initialize();
    if (result != ISSAC_SUCCESS) {
        printf("[ERROR] %s\n", ISSAC_GetErrorMessage(result));
        return 1;
    }
    return 0;
}

static int sample_dl_arl() {
    ISSAC_RETURN result;
    DLCONTEXT dlcontext;
    CERTIFICATEREVLIST arl;

    printf("sample_dl_arl() => ");

    ISSAC_DLCONTEXT_Create(&dlcontext);
    ISSAC_CERTIFICATEREVLIST_Create(&arl);

    {
        // ARL 
        // ARL Ϲ Ʈ ũⰡ ũ Ƿ, ARL ߱  ġ ԵǴ 찡 .
        const char *arlIssuerDn = "cn=KISA RootCA 4,ou=Korea Certification Authority Central,o=KISA,c=KR";

        result = ISSAC_DLCONTEXT_Set(&dlcontext, "ldap.signgate.com", 389, arlIssuerDn);
        if (result == ISSAC_SUCCESS) {
            result = ISSAC_DL_ReadCERTIFICATEREVLIST_Timeout(&arl, arlIssuerDn, NULL, &dlcontext, 4);
        }
        // ARL 
    }

    ISSAC_DLCONTEXT_Delete(&dlcontext);
    ISSAC_CERTIFICATEREVLIST_Delete(&arl);

    if (result == ISSAC_SUCCESS) {
        printf("[OK]\n");
        return 0;
    } else {
        printf("[ERROR] %s\n", ISSAC_GetErrorMessage(result));
        return 1;
    }
}

int main() {
    int result;

    result = sample_setup();
    if (result != 0) {
        return result;
    }

    return sample_dl_arl();
}
