#include <stdio.h>

#include "issacapi_dl.h"

static int sample_setup() {
    ISSAC_RETURN result;

    result = ISSAC_Initialize();
    if (result != ISSAC_SUCCESS) {
        printf("[ERROR] %s\n", ISSAC_GetErrorMessage(result));
        return 1;
    }
    return 0;
}

static int sample_dl_certificate() {
    ISSAC_RETURN result;
    DLCONTEXT dlcontext;
    CERTIFICATE *certArray = NULL;
    int certNum = 0;
    const char *euckrDn = "cn=׽Ʈ(-A),ou=RA,ou=TEST,ou=TEST߱޿,ou=licensedCA,o=KICA,c=KR";

    printf("sample_dl_certificate() => ");

    ISSAC_DLCONTEXT_Create(&dlcontext);

    {
        char utf8Dn[512] = { 0, };
        int utf8DnLen = 0;

        //  . ѱ Ե , ڼ UTF-8 ̾ Ѵ. (ϵڵ ѱ ڼ Ϸ  ޶  ִ)
        result = ISSAC_EuckrToUtf8(utf8Dn, &utf8DnLen, (char *) euckrDn);
        if (result == ISSAC_SUCCESS) {
            result = ISSAC_DLCONTEXT_Set(&dlcontext, "ldap.signgate.com", 389, utf8Dn);
        }
        if (result == ISSAC_SUCCESS) {
            result = ISSAC_DL_ReadCERTIFICATE(&certArray, &certNum, utf8Dn, NULL, &dlcontext);
        }

        //   signCert.der, kmCert.der       óѴ.
        if (result == ISSAC_SUCCESS) {
            int certIndex;
            for (certIndex = 0; certIndex < certNum; certIndex++) {
                char subjectDn[512] = { 0, };
                result = ISSAC_CERTIFICATE_GetSubjectName(subjectDn, sizeof(subjectDn), certArray + certIndex);
                if (result != ISSAC_SUCCESS) {
                    break;
                }
                if (strncmp(subjectDn, euckrDn, sizeof(subjectDn) - 1) != 0) {
                    result = ISSAC_FAIL;
                    break;
                }
            }
            ISSAC_DL_DeleteCERTIFICATEarray(&certArray, certNum);
        }
    }

    ISSAC_DLCONTEXT_Delete(&dlcontext);

    if (result == ISSAC_SUCCESS) {
        printf("[OK]\n");
        return 0;
    } else {
        printf("[ERROR] %s\n", ISSAC_GetErrorMessage(result));
        return 1;
    }
}

int main() {
    int result;

    result = sample_setup();
    if (result != 0) {
        return result;
    }

    return sample_dl_certificate();
}
