#include <stdio.h>

#include "issacapi_dl.h"

static int sample_setup() {
    ISSAC_RETURN result;

    result = ISSAC_Initialize();
    if (result != ISSAC_SUCCESS) {
        printf("[ERROR] %s\n", ISSAC_GetErrorMessage(result));
        return 1;
    }
    return 0;
}

static int sample_dl_crl() {
    ISSAC_RETURN result;
    DLCONTEXT dlcontext;
    CERTIFICATEREVLIST crl;

    printf("sample_dl_crl() => ");

    ISSAC_DLCONTEXT_Create(&dlcontext);
    ISSAC_CERTIFICATEREVLIST_Create(&crl);

    {
        // CRL .   UTF-8 ̾ , crl ̸ ѱ۷ ϴ   ̴.
        const char *crlDn = "ou=dp7p15029,ou=crldp,ou=AccreditedCA,o=KICA,c=KR";

        result = ISSAC_DLCONTEXT_Set(&dlcontext, "ldap.signgate.com", 389, crlDn);
        if (result == ISSAC_SUCCESS) {
            result = ISSAC_DL_ReadCERTIFICATEREVLIST_Timeout(&crl, crlDn, NULL, &dlcontext, 4);
        }
        // CRL 
    }

    ISSAC_DLCONTEXT_Delete(&dlcontext);
    ISSAC_CERTIFICATEREVLIST_Delete(&crl);

    if (result == ISSAC_SUCCESS) {
        printf("[OK]\n");
        return 0;
    } else {
        printf("[ERROR] %s\n", ISSAC_GetErrorMessage(result));
        return 1;
    }
}

int main() {
    int result;

    result = sample_setup();
    if (result != 0) {
        return result;
    }

    return sample_dl_crl();
}
