#include <stdio.h>

#include "issacapi_bs.h"
#include "issacapi_ea_sig.h"
#include "issacapi_usr.h"
#include "issacapi_errorcode.h"

/**
 * <pre>
 * ߱޴ : cn=̴ذ(IniPer)200080120190311900000003,ou=INIPASS2000,ou=personal,o=INIPASS,c=KR
 * ߱   : cn=INIPASS CA,ou=AccreditedCA,o=INIPASS,c=KR
 * ȿⰣ : 2019/03/11 ~ 2019/06/09
 * Ű   : RSA 2048
 *  ˰ : sha256WithRSAEncryption
 * </pre>
 */
static const char *certB64 =
    "MIIFszCCBJugAwIBAgICAZkwDQYJKoZIhvcNAQELBQAwSzELMAkGA1UEBhMCS1IxEDAOBgNVBAoMB0lOSVBBU1MxFTATBgNVBAsMDEFjY3JlZGl0"
    "ZWRDQTETMBEGA1UEAwwKSU5JUEFTUyBDQTAeFw0xOTAzMTEwNTA0NTlaFw0xOTA2MDkxNDU5NTlaMIGCMQswCQYDVQQGEwJLUjEQMA4GA1UECgwH"
    "SU5JUEFTUzERMA8GA1UECwwIcGVyc29uYWwxFDASBgNVBAsMC0lOSVBBU1MyMDAwMTgwNgYDVQQDDC/snbTri4jthY3qsJzsnbgoSW5pUGVyKTIw"
    "MDA4MDEyMDE5MDMxMTkwMDAwMDAwMzCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAIrdG5fdGmTME6FpzwbFb5HBRojBKfbsSrpyiHlq"
    "n1uKBaaajoBsYIeNbOwg7roLkQvm0uodET4G3MWRJaAGGOtbIKffFd7nPo1oELinQvF2Gcr2siwgSI7YbvAnPI5s11Dc4D86NqS/b+tC/zSNuLUX"
    "bBKVoxUHG4E7IEEcK1zF5LLalvPFFwVhLx/IsylCvkHWw900jKGeBgBsFDklRDdSFI/jwiMnJgMtGYFxakXh6pMgzof4DQNCsA/8beHQ37iBXKoA"
    "380/tB3TFDJA2AB0KuOQDeFbvRLaiyqx7UNcWM6AM7ubcrj4B2XoS6zPTo85Dx6iQTaLPkwEQ6ilXDECAwEAAaOCAmcwggJjMIGPBgNVHSMEgYcw"
    "gYSAFKORisOXVoYiGgulHJtUsiz4oqcFoWikZjBkMQswCQYDVQQGEwJLUjENMAsGA1UECgwES0lTQTEuMCwGA1UECwwlS29yZWEgQ2VydGlmaWNh"
    "dGlvbiBBdXRob3JpdHkgQ2VudHJhbDEWMBQGA1UEAwwNS0lTQSBSb290Q0EgNIICECQwHQYDVR0OBBYEFFIslyxQUQ9/Bdlkw+0AiXaD150XMA4G"
    "A1UdDwEB/wQEAwIGwDB8BgNVHSABAf8EcjBwMG4GCiqDGoyaRAUFAQEwYDAuBggrBgEFBQcCARYiaHR0cDovL3d3dy5pbmlwYXNzLmNvbS9tYS9Q"
    "T18wNC5hZzAuBggrBgEFBQcCAjAiHiDHdAAgx3jJncEcspQAIKz1x3jHeMmdwRwAIMeFssiy5DBuBgNVHREEZzBloGMGCSqDGoyaRAoBAaBWMFQM"
    "D+ydtOuLiO2FjeqwnOyduDBBMD8GCiqDGoyaRAoBAQEwMTALBglghkgBZQMEAgGgIgQgeIkP8+qhOB5hQLxSg2CoENfDcrxKlJG9Fskt3RRSt4ow"
    "dwYDVR0fBHAwbjBsoGqgaIZmbGRhcDovL2Rpci5pbmlwYXNzLmNvbTozODkvb3U9ZHA4MXAxLG91PWNybGRwLG91PUFjY3JlZGl0ZWRDQSxvPUlO"
    "SVBBU1MsYz1rcj9jZXJ0aWZpY2F0ZVJldm9jYXRpb25MaXN0MDkGCCsGAQUFBwEBBC0wKzApBggrBgEFBQcwAYYdaHR0cDovL29jc3AuaW5pcGFz"
    "cy5jb206NDYxMi8wDQYJKoZIhvcNAQELBQADggEBADouu5wh+r1t0+elJZAScMwIBUNRcG/41aV6M9mjXVHTPj+874IeOqghlvVPdiRPGQl6RdXy"
    "E+QtVa2VM2yTgQjB0WP8iVRJmcHGj5oH2X1HV6Og0FhmgL+BNflrEzTuvu3FnYUgCynDGCNTl26beP2CVXUVcPiGasKSwxIoya8RtybzTQD1gZLv"
    "ZDEXqAGeYFKPNU+V4mTolDaB7+P+W98cGD47ai4efy0e4id8x6cl9eAMA7rCkshylxZnuPk6lOflR1SsRgAyzcT288yRuViEc/rKGGhrYz9fJGuS"
    "5Sz0PUTKzkxxn3/BPOhvRdgKSRBMX4ZGFqgiynj6qbZBqnQ=";
static unsigned char certBytes[4096] = { 0, };
static int certBytesLen = 0;
static const char *priKeyB64 =
    "MIIFEDAaBggqgxqMmkQBDzAOBAg0ThZK2Xze5gICCAAEggTw5gK4W3R5WZIHGfvDlATewr8N18VcvqPpO8ruIXHSQBeJpUvTiVZMU+2AJfkTGzXZ"
    "xLfd+oUF+uzBPm2MV5xPVQsDr6ktFsTrqSUe+gunx9M9XH9UHPPj6xqwdsv0JJLTAQx/vi+Cd3AP0rYmxMvamUfXk7UQvsGI32Wj0P1WJ1bkgRNm"
    "IO+uMGKH/bp78W20L4CyhhxrlaAeZT0uVE6HvVxONHKxbmq8BDKKrWp5QIcihQhXgvjxtH7UjwQaOqZZOBZn4eN6aZZahn20jCJqoSGYUSGzGHaT"
    "HcOTnQqxLJIo0n043nUKPglVU58uNPUjEy17hhoWs/r4unfVmQqpaIChJjQNKy82MptXvtyPCtyf/bvHBA8PL7oDfZy+UNtQIXGZW+jFMTr5DMQ2"
    "6LwzyHg8BD5dlSl5Yw6UtpwrmL06fso7vBbZc7gV2QRFaFCH734/UJ3ig41/yEPGUvEwlB9y3xNeTaNQPA+9AZfnSaRHX93Z5iOf2VU7Q9YcIRp4"
    "RRC6K6kENNNGszAaFlSqNMN5rWuF0/9xX7gYF7sqqdlAAClAZMM/JUdD5SOS412AyKJHuIpC4pngF65AebihkjjJxL86+h1qZ2wGq2e07hY16l2r"
    "YsU8zpUrJNBYaH01xIRm9+zJHXUbLxD9moNGAAQcSfE1EDhykTmWL9FNtf+94xsDfLAdIB9OXt9hQBBYHm44iWxmqz35C23SPBba6zZAobjFt9mv"
    "nPpFLJ6nGRdojKvxUhk+zd4UPYpMXvdHx9m4XlPTUcdSzjXx7cjsxeRaAYSUPm/M1fBOhnisRII13r/z5HhKM3jt11XW1670DKv2+lPinE28iOOE"
    "qpVH5ja4rRb8JCYLaWu6QchM+5g3ALBUC5K10RJ80RthgHsDOeQS7tSJPALZGQYB8X92LGm+AypvC6DIIJMBWv0QxTPpY7aLoNZ1OIjzRiQX/vaz"
    "IhCo8uPGMbhictVxSXxD1pMnkApDcdU628xoTeZwcfzx2j2MaDQPwefmxKANhJqx+rLtLyNqocjUm5FadwNKfp8Yrk+gMQ3v1KvO+LuFtq8BcQXw"
    "EkbrYv2byX793kqvdDa4Q7DgMc4c47UtiDVmBEmfNWFiSj0Y8K6VFcxCLg5NnD84L91/kDrTMK2vp3Oqm9yaVCz6I7ljhjfxfwf/DfUjvgmajYjH"
    "WZ40dGL+NxLPWwajwTZ3Ed7StNzj/sKFL1lH3fDH/99i4duVIrfQntVqZATpo3pQ6EaWj/HBInFpsXthcXGC3kMZt2aPDn8hKp13ypb8Tp4EYd9w"
    "v7uTgbK/InjgvjNYq/6NjxqOd1YFK1u0+w0r0cIMKeoGMhbBpsRKNamhDfBlekewk5mBioQzlOZRStZakUDdhzj3YtQdPSrR4TYqnVIFp7ylh+Jz"
    "D11Sj5NmgmMWwYhwuw2ceh2Rg+qU/C2pDw1loRd+G6XE6Pv2+YOnCGk+ne8Wg92fSSCNkcHmai3JyWTjT1RQSfWUHGHfaKQUKkm3E0p8JdMCaJt7"
    "9wJYIJF5LnCFqUlVEOQbjB0F3eVaw7YpzKd/layjwRT6TvXVFMknFtYaVGKPEZGHf/FXCVOR9IPYY6riPDwhNCHz6/n0h2v2MZ0wdch8q43V/rMP"
    "s8OvwMFhUyxevCtxajQsdIF2lM4yAUJrZgFP5OuJ1ycfF1z/vRsl5g==";
static unsigned char priKeyBytes[2048] = { 0, };
static int priKeyBytesLen = 0;
static const char *password = "Inipass@2019";

static int sample_setup() {
    ISSAC_RETURN result;

    result = ISSAC_Initialize();
    if (result != ISSAC_SUCCESS) {
        printf("[ERROR] %s\n", ISSAC_GetErrorMessage(result));
        return 1;
    }
    result = ISSAC_BASE64_Decode(certBytes, &certBytesLen, sizeof(certBytes), certB64);
    if (result != ISSAC_SUCCESS) {
        printf("[ERROR] %s\n", ISSAC_GetErrorMessage(result));
        return 1;
    }
    result = ISSAC_BASE64_Decode(priKeyBytes, &priKeyBytesLen, sizeof(priKeyBytes), priKeyB64);
    if (result != ISSAC_SUCCESS) {
        printf("[ERROR] %s\n", ISSAC_GetErrorMessage(result));
        return 1;
    }
    return 0;
}

static ISSAC_RETURN sample_make_challenge(unsigned char *challenge, int *challengeLen, int challengeBufLen) {
    ISSAC_RETURN result;
    EASIGCONTEXT verifierInfo;

    ISSAC_EASIGCONTEXT_Create(&verifierInfo);

    result = ISSAC_EA_SIG_MakeChallenge(challenge, challengeLen, challengeBufLen, &verifierInfo);

    ISSAC_EASIGCONTEXT_Delete(&verifierInfo);

    return result;
}

static ISSAC_RETURN sample_make_response(unsigned char *response, int *responseLen, int responseBufLen, const unsigned char *challenge, int challengeLen) {
    ISSAC_RETURN result;
    CERTIFICATE cert;
    PRIVATEKEY priKey;
    EASIGCONTEXT proverInfo;

    ISSAC_CERTIFICATE_Create(&cert);
    ISSAC_PRIVATEKEY_Create(&priKey);
    ISSAC_EASIGCONTEXT_Create(&proverInfo);

    //  б
    result = ISSAC_CERTIFICATE_Read_Memory(&cert, certBytes, certBytesLen);
    // Ű б
    if (result == ISSAC_SUCCESS) {
        result = ISSAC_PRIVATEKEY_Read_Memory(&priKey, priKeyBytes, priKeyBytesLen, password);
    }
    // 䰪 
    if (result == ISSAC_SUCCESS) {
        result = ISSAC_EA_SIG_MakeResponse(response, responseLen, responseBufLen, challenge, challengeLen, &priKey, &cert, &proverInfo);
    }

    ISSAC_CERTIFICATE_Delete(&cert);
    ISSAC_PRIVATEKEY_Delete(&priKey);
    ISSAC_EASIGCONTEXT_Delete(&proverInfo);

    return result;
}

static ISSAC_RETURN sample_verify_response(const unsigned char *challenge, int challengeLen, const unsigned char *response, int responseLen) {
    ISSAC_RETURN result;
    EASIGCONTEXT verifierInfo;

    ISSAC_EASIGCONTEXT_Create(&verifierInfo);

    // 䰪 
    //  - ç   ߴ EASIGCONTEXT ü ϰ ִٸ challenge ־ ʿ , ƴϸ ç ־ Ѵ.
    //  - ü ٴ ç ϴ     Ƽ  õ ç ϴ  Ѵ.
    result = ISSAC_EA_SIG_AuthenticatePeerMessage(challenge, challengeLen, response, responseLen, &verifierInfo);
    if (result == ISSAC_SUCCESS) {
        // 䰪    ȿ 
        CERTIFICATE cert;
        ISSAC_CERTIFICATE_Create(&cert);
        result = ISSAC_EA_SIG_GetPeerCertificate(&cert, &verifierInfo);
        // inipass   ׽Ʈ Ұ
        // if (result == ISSAC_SUCCESS) {
        //     // ISSAC_USR_CertPathValidation()    LDAP Ǵ 쿡 . API  .
        //     result = ISSAC_USR_CertPathValidation(&cert);
        // }
        ISSAC_CERTIFICATE_Delete(&cert);
    }

    ISSAC_EASIGCONTEXT_Delete(&verifierInfo);

    return result;
}

static int sample_easig_basic() {
    ISSAC_RETURN result;
    char challenge[64] = { 0, };
    int challengeLen = 0;
    char response[2048] = { 0, };
    int responseLen = 0;

    // ü   Ŭ̾Ʈ ȣۿ ؾ Ѵ.  õ  ° иϿ.

    printf("sample_easig_basic() => ");

    // () : ç Ͽ Ŭ̾Ʈ(û) 
    result = sample_make_challenge(challenge, &challengeLen, sizeof(challenge));

    // Ŭ̾Ʈ(û) :  ޹ ç Ͽ 䰪 
    if (result == ISSAC_SUCCESS) {
        result = sample_make_response(response, &responseLen, sizeof(response), challenge, challengeLen);
    }

    // () : Ŭ̾Ʈ ޹ 䰪 
    if (result == ISSAC_SUCCESS) {
        result = sample_verify_response(challenge, challengeLen, response, responseLen);
    }

    //if (result == ISSAC_SUCCESS) {
    // ׽Ʈ   츦 Ͽ ᵵ  Ѵ. (Ǽ ݿ   óؾ )
    if (result == ISSAC_SUCCESS || result == ER_VERIFY_EXPIRED) {
        printf("[OK]\n");
        return 0;
    } else {
        printf("[ERROR] %s\n", ISSAC_GetErrorMessage(result));
        return 1;
    }
}

int main() {
    int result;

    result = sample_setup();
    if (result != 0) {
        return result;
    }

    return sample_easig_basic();
}
