#include <stdio.h>

#include "issacapi_hmac.h"

static const unsigned char *plaintext = (const unsigned char *) "This is a test text";
static int plaintextSize = 19; // strlen("This is a test text");
static const unsigned char secretKey[] = {
    0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08,
    0x09, 0x0A, 0x0B, 0x0C, 0x0D, 0x0E, 0x0F, 0x10,
    0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17, 0x18,
    0x19, 0x1A, 0x1B, 0x1C, 0x1D, 0x1E, 0x1F, 0x20,
    0x21, 0x22, 0x23, 0x24, 0x25, 0x26, 0x27, 0x28,
    0x29, 0x2A, 0x2B, 0x2C, 0x2D, 0x2E, 0x2F, 0x30
};

static int sample_setup() {
    EErrorCode result = wasdk_init();
    if (result != EEC_Success) {
        printf("[ERROR] %s\n", wasdk_error_message(result));
        return 1;
    }
    return 0;
}


int sample_hmac_basic() {
    ISSAC_RETURN result;
    HMAC_CONTEXT context;
    unsigned char hmac[MAX_HASH_SIZE] = { 0, };
    int hmacLen = 0;

    printf("sample_hmac_basic() => ");

    ISSAC_HMAC_CONTEXT_Create(&context);

    // Ű ؽ ˰ 
    //  - sizeof(secretKey) Է ؽ ˰ ũ⺸ ĿѴ. (API  )
    result = ISSAC_HMAC_Initialize(&context, secretKey, sizeof(secretKey), ISSACAPI_SHA256);
    //  ޽ ߰
    if (result == ISSAC_SUCCESS) {
        result = ISSAC_HMAC_Update(&context, plaintext, plaintextSize);
    }
    // HMAC ° 
    if (result == ISSAC_SUCCESS) {
        result = ISSAC_HMAC_Finalize(hmac, &hmacLen, sizeof(hmac), &context);
    }

    ISSAC_HMAC_CONTEXT_Delete(&context);

    if (result == ISSAC_SUCCESS) {
        printf("[OK]\n");
        return 0;
    } else {
        printf("[ERROR] %s\n", ISSAC_GetErrorMessage(result));
        return 1;
    }
}

int main() {
    int result;

    result = sample_setup();
    if (result != 0) {
        return result;
    }

    return sample_hmac_basic();
}
