#include <stdio.h>

#include "issacapi_ka.h"

static int sample_setup() {
    ISSAC_RETURN result;

    result = ISSAC_Initialize();
    if (result != ISSAC_SUCCESS) {
        printf("[ERROR] %s\n", ISSAC_GetErrorMessage(result));
        return 1;
    }
    return 0;
}

static ISSAC_RETURN sample_ka_initialize(unsigned char *sessionInfo, int *sessionInfoSize, int sessionInfoBufferSize, KACONTEXT *kacontext) {
    ISSAC_RETURN result;
    // Param 
    result = ISSAC_KACONTEXT_SetParam_ECDH(kacontext, ISSACAPI_EC_CURVE_P256);
    // KDF 
    if (result == ISSAC_SUCCESS) {
        result = ISSAC_KACONTEXT_SetKDF(kacontext, -1, ISSACAPI_SHA256);
    }
    if (result == ISSAC_SUCCESS) {
        result = ISSAC_KA_Initialize(sessionInfo, sessionInfoSize, sessionInfoBufferSize, kacontext);
    }

    return result;
}

static ISSAC_RETURN sample_ka_finalize(unsigned char *sessionKey, int sessionKeySize, unsigned char *peerSessionInfo, int peerSessionInfoSize, KACONTEXT *kacontext) {
    ISSAC_RETURN result;

    result = ISSAC_KA_Finalize(kacontext, peerSessionInfo, peerSessionInfoSize);
    // Ű 
    if (result == ISSAC_SUCCESS) {
        result = ISSAC_KA_GetSessionKey(sessionKey, sessionKeySize, kacontext);
    }

    return result;
}

static int sample_ka_basic() {
    ISSAC_RETURN result;
    KACONTEXT peerA;
    KACONTEXT peerB;
    unsigned char sessionInfoA[2048] = { 0, };
    int sessionInfoLenA = 0;
    unsigned char sessionInfoB[2048] = { 0, };
    int sessionInfoLenB = 0;
    unsigned char sessionKeyA[16] = { 0, };
    unsigned char sessionKeyB[16] = { 0, };

    printf("sample_ka_basic() => ");

    // KA  Ű   ٸ PC  Ǵ  Ϲ̴.  õ  ° иϿ.

    ISSAC_KACONTEXT_Create_Ex(&peerA, KEX_ECDH);
    ISSAC_KACONTEXT_Create_Ex(&peerB, KEX_ECDH);

    // A :    (B    ʿ)
    result = sample_ka_initialize(sessionInfoA, &sessionInfoLenA, sizeof(sessionInfoA), &peerA);

    // B :   
    if (result == ISSAC_SUCCESS) {
        result = sample_ka_initialize(sessionInfoB, &sessionInfoLenB, sizeof(sessionInfoB), &peerB);
    }
    // B : A   Ͽ Ű  (A    ʿ)
    if (result == ISSAC_SUCCESS) {
        result = sample_ka_finalize(sessionKeyB, sizeof(sessionKeyB), sessionInfoA, sessionInfoLenA, &peerB);
    }

    // A : B   Ͽ Ű 
    if (result == ISSAC_SUCCESS) {
        result = sample_ka_finalize(sessionKeyA, sizeof(sessionKeyA), sessionInfoB, sessionInfoLenB, &peerA);
    }

    ISSAC_KACONTEXT_Delete(&peerA);
    ISSAC_KACONTEXT_Delete(&peerB);
    
    if (result == ISSAC_SUCCESS) {
        printf("[OK]\n");
        return 0;
    } else {
        printf("[ERROR] %s\n", ISSAC_GetErrorMessage(result));
        return 1;
    }
}

int main() {
    int result;

    result = sample_setup();
    if (result != 0) {
        return result;
    }

    return sample_ka_basic();
}
