#include <stdio.h>

#include "issacapi_md.h"

static const unsigned char *plaintext = (const unsigned char *) "This is a test text";
static int plaintextSize = 19; // strlen("This is a test text");

static int sample_setup() {
    EErrorCode result = wasdk_init();
    if (result != EEC_Success) {
        printf("[ERROR] %s\n", wasdk_error_message(result));
        return 1;
    }
    return 0;
}


int sample_md_basic() {
    ISSAC_RETURN result;
    MDCONTEXT context;
    unsigned char md[MAX_HASH_SIZE] = { 0, };
    int mdLen = 0;

    printf("sample_md_basic() => ");

    ISSAC_MDCONTEXT_Create(&context);

    // ؽ ˰ 
    result = ISSAC_MD_Initialize(&context, ISSACAPI_SHA256);
    //  ޽ ߰
    if (result == ISSAC_SUCCESS) {
        result = ISSAC_MD_Update(&context, plaintext, plaintextSize);
    }
    // ؽ ° 
    if (result == ISSAC_SUCCESS) {
        result = ISSAC_MD_Finalize(md, &mdLen, sizeof(md), &context);
    }

    ISSAC_MDCONTEXT_Delete(&context);

    if (result == ISSAC_SUCCESS) {
        printf("[OK]\n");
        return 0;
    } else {
        printf("[ERROR] %s\n", ISSAC_GetErrorMessage(result));
        return 1;
    }
}

int main() {
    int result;

    result = sample_setup();
    if (result != 0) {
        return result;
    }

    return sample_md_basic();
}
