#include <stdio.h>

#include "issacapi_pe.h"

/**
 * <pre>
 * ߱޴ : cn=׽Ʈ(-A),ou=RA,ou=TEST,ou=TEST߱޿,ou=licensedCA,o=KICA,c=KR
 * ߱   : cn=signGATE CA4,ou=AccreditedCA,o=KICA,c=KR
 * ȿⰣ : 2013/06/18 ~ 2014/07/11
 * Ű   : RSA 2048
 *  ˰ : sha256WithRSAEncryption
 * </pre>
 */
static const char *certB64 =
    "MIIFyjCCBLKgAwIBAgIEAlEqGjANBgkqhkiG9w0BAQsFADBKMQswCQYDVQQGEwJLUjENMAsGA1UECgwES0lDQTEVMBMGA1UECwwMQWNjcmVkaXRl"
    "ZENBMRUwEwYDVQQDDAxzaWduR0FURSBDQTQwHhcNMTMwNjE4MDQxOTUyWhcNMTQwNzExMTQ1OTU5WjCBkjELMAkGA1UEBhMCS1IxDTALBgNVBAoM"
    "BEtJQ0ExEzARBgNVBAsMCmxpY2Vuc2VkQ0ExFjAUBgNVBAsMDVRFU1TrsJzquInsmqkxFjAUBgNVBAsMDVRFU1Tsnbjspp3shJwxETAPBgNVBAsM"
    "CFJB7IS87YSwMRwwGgYDVQQDDBPthYzsiqTtirgo6rCc7J24LUEpMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAqMvo0a+XEcu46zBr"
    "ScFFstA9br1I/23/0rZAzbka9trkbavX/yU/WrqcR/OW1T3C9jzEc9wsJV6Holvy+5Nfrs0rT9dKLShv62dNOI4HNQuUJ82p8Mf9hE1aor/q65v7"
    "LFlhldSfqQwcmQHVkhE92T54gBYM3tiI14pTRxHXTCC9J0RgR73lyj2K9DCi3EHSFDWxQsrk7498r4bDXmCSLy8N+9cgp0ycf+a16cF2IgkD9fCp"
    "GB47MjD6YK6J4G/AlhrYeE3GgNFs2DcdoUXA2tu3RMEQtL/jUc7RkfrCYXVUeQzNs9yU+qkf9gE27FZoOLasTn+iRKLNI1BTxbMACQIDAQABo4IC"
    "bTCCAmkwgY8GA1UdIwSBhzCBhIAUrlL9Dg4B+DCGN372GMZJJUpgCXChaKRmMGQxCzAJBgNVBAYTAktSMQ0wCwYDVQQKDARLSVNBMS4wLAYDVQQL"
    "DCVLb3JlYSBDZXJ0aWZpY2F0aW9uIEF1dGhvcml0eSBDZW50cmFsMRYwFAYDVQQDDA1LSVNBIFJvb3RDQSA0ggIQCjAdBgNVHQ4EFgQUNwJ6J8tk"
    "JTw196s9SyXGLvK7hawwDgYDVR0PAQH/BAQDAgbAMHUGA1UdIARuMGwwagYKKoMajJpEBQIBAjBcMCwGCCsGAQUFBwIBFiBodHRwOi8vd3d3LnNp"
    "Z25nYXRlLmNvbS9jcHMuaHRtbDAsBggrBgEFBQcCAjAgHh7HdAAgx3jJncEcspQAIKz1x3jHeMmdwRzHhbLIsuQwgYgGA1UdEQSBgDB+gRNoeWNo"
    "dWxAc2lnbmdhdGUuY29toGcGCSqDGoyaRAoBAaBaMFgME+2FjOyKpO2KuCjqsJzsnbgtQSkwQTA/BgoqgxqMmkQKAQEBMDEwCwYJYIZIAWUDBAIB"
    "oCIEIF1OVexuxxa06/5bQkFRznWf2JV6UaEST0o8H2CX8BanMF4GA1UdHwRXMFUwU6BRoE+GTWxkYXA6Ly9sZGFwLnNpZ25nYXRlLmNvbTozODkv"
    "b3U9ZHA2cDk0NzQsb3U9Y3JsZHAsb3U9QWNjcmVkaXRlZENBLG89S0lDQSxjPUtSMEQGCCsGAQUFBwEBBDgwNjA0BggrBgEFBQcwAYYoaHR0cDov"
    "L29jc3Auc2lnbmdhdGUuY29tOjkwMjAvT0NTUFNlcnZlcjANBgkqhkiG9w0BAQsFAAOCAQEAHdOAJIjVc+ToFRb08LbciVZQVhxcqOE48gq98Q+2"
    "1bUH919MeRMnkENw362YHtpluRlLTWxquHVoGutB20ciHRMScdqCRShGQv+Nb2756ZmmOPsC1q+LFiImOlmv2wnyQir5zATktvwuiM4/aXWL6wA+"
    "P1hq2rw3IqUC4Idk21MJZY8EDa71AOwo2tUy/vodMLxqI5N48iuEyKles5TG/Iw5tWhh6qdOX4VF8QEsFY7kLdKoW8PnlFgjHt6vARtswfUTVI5X"
    "EaSlxjvQ6LCUJpGp5iwxJxzaXJ+kKQEGyVRTcucKlzTZ0mgJwk71DmZN1cfSqYtpmr0nM1X14hEAXA==";
static unsigned char certBytes[4096] = { 0, };
static int certBytesLen = 0;
static const char *priKeyB64 =
    "MIIFEDAaBggqgxqMmkQBDzAOBAjoS6syNypRxAICBAAEggTwPM2aWi0mIFieUG3EfeX2hJuQkS7mE/oPwwe8xpSvJrZBSU8Z1QZjKIsA5T+/2cR4"
    "9t/OWqqs8Gi0NFz9F2/MsErMUenVsSdfz+TrKtMpmY+vtzeaWcaKhjLI0jkUfQFjQC1/HE+JTBbPbWiTZbBppNslBpOvB8LwiQ6hhYRlsV7JQUrA"
    "+sRGeiwaWlPtZ4tv7XRC2L4qt9rzPLCywR4kbm9KwD20STCXZIOCthjCS0epoTlF9FB0JLurXY/1Oy+xsOJkH3j+6XVo7On6DIw+2VHBtOczhvvp"
    "b79htB3kcPfr02bHZ0QeypMmYLthjUlBBqRgciX7O8jUbAcKUTlojrQh/8KaK8qUkLt8WoNmtLQGoq0h8jeFqdGjSHafSP25kyKFQv3AM0hIQd1n"
    "ZmVlDJyMyVDz8EriFXolyKVg0YagEKG8sRDA79Kn/ftHskriZyEldM1/8hgCTtbWnBbTuZsWDMIrO1Z16CtpYTVmFkE0Ix1n4J3uJtHJJsT63WpY"
    "KzRMAQBg1w0PFQ4IisnJbLS4G7pxmkENaQT8or6jOb1e+G/qyU0rTK4H7+oab5g7XyaJp8NxH8a+cGSFqBK3RPTWHt9YUpGpv9y0v+WpgorQLMA1"
    "v/qIoBxg3mp9zs0kKjAHvOGySQ/vZ8ave9611LTfWoaHde8BVCCCoaNYdAKM6642zqEcpXAsp0JB6YqCzgm0UskuLbZ4LXg9zcFSO+jmHhTp6DPo"
    "xvCrh3M3NNaOpoM/MLofbL43MDmfkTe9RQBdssRCGV6quGvjVDuZt98b/nYVcF10+PTY9YnYwLzW3/V87L/O+4AoHqVGCt4xPBWjMgBCjyvdVZYw"
    "MzdwaFZvb/DWr2Y8zu6g0kWcELOATrjhYOKfysYO7qn/rSvXBE4/IvwnBA4gKTPjwePQ18uDQmlURbsgnAuMzKdnafFgQyE/48FC//mL9PisfBLO"
    "sVucdMpelCdzvzXxeMphjA3mQo4P/QD/LMqvVtgoGhNPPhthqz5eEq8iGyZm6sxoA9wJeyt7EGEWlsgttvV1zJiXsHiejZtiJaGWiU2jjX3qhJhb"
    "TIarsphm/bRUkWBzy8qxHIo3AMsBcMIX0Mvch0BQ6Uvd/fK81I2KmuAPM4KNilQqVQRwYaczC5Syhj84zTPGLFCTXLwTShJDI5m7jquaazylZ0iW"
    "zzl1T17EjvSARUZ6I5i4Uubvo7t7qxJC47gHVrlW9bk2oqKrej8A7IZ7lHElZaZv3eo+8gi1SAX+bOfXLJNd3MhUKYPPmd/jYDpA3wkpb3ZU3kP0"
    "kAqfAocJ/KQIDrPjpdgzMrBRylKZWseyPha3W8Fffk+woYlD1jsiZZ6dROqw1YkLJ/nWaDT9/6W0T6oTSz9X1zEhD5ov2bkHV8WZmmZ5Ll7cBoqp"
    "q6yyfVZclEZu8y1WiMvHnruTABLaW+I9yo81Y3o3QC2bssfvftKWd21joV22yUB6lhBnBeTm2vyDjunHdPabO0BdzfjQvpA0M7cMCXZC3JSntctS"
    "fCmvnnxVamkiuCpB8zQaP836jw1S1YslSSZfdeb85vgoFb21UDfu+aeezPJ3oVxN+isYlhptTls0IadyTUslyN6rveIrZzTOSVwsaBZspnHJm4Bp"
    "cBWODaQ7iaqX0r1NbfDTlYpkRVeaQ8htR396alvaO0KjcPaVuMO5VA==";
static unsigned char priKeyBytes[2048] = { 0, };
static int priKeyBytesLen = 0;
static const char *password = "a123456A";

static const unsigned char *plaintext = (const unsigned char *) "This is a test text";
static int plaintextSize = 19; // strlen("This is a test text");

static int sample_setup() {
    ISSAC_RETURN result;

    result = ISSAC_Initialize();
    if (result != ISSAC_SUCCESS) {
        printf("[ERROR] %s\n", ISSAC_GetErrorMessage(result));
        return 1;
    }
    result = ISSAC_BASE64_Decode(certBytes, &certBytesLen, sizeof(certBytes), certB64);
    if (result != ISSAC_SUCCESS) {
        printf("[ERROR] %s\n", ISSAC_GetErrorMessage(result));
        return 1;
    }
    result = ISSAC_BASE64_Decode(priKeyBytes, &priKeyBytesLen, sizeof(priKeyBytes), priKeyB64);
    if (result != ISSAC_SUCCESS) {
        printf("[ERROR] %s\n", ISSAC_GetErrorMessage(result));
        return 1;
    }
    return 0;
}

static int sample_pe_envelopeddata() {
    ISSAC_RETURN result;
    char encrypted[4096] = { 0, };
    int encryptedSize = 0;

    printf("sample_pe_envelopeddata() => ");

    // ȣȭ
    {
        CERTIFICATE cert;
        ISSAC_CERTIFICATE_Create(&cert);

        //  б
        result = ISSAC_CERTIFICATE_Read_Memory(&cert, certBytes, certBytesLen);
        //  ޽ ȣȭ
        if (result == ISSAC_SUCCESS) {
            result = ISSAC_PE_Encrypt(encrypted, &encryptedSize, sizeof(encrypted), plaintext, plaintextSize, &cert, ISSACAPI_SEED);
        }

        ISSAC_CERTIFICATE_Delete(&cert);
    }

    // ȣȭ
    if (result == ISSAC_SUCCESS) {
        PRIVATEKEY priKey;
        char decrypted[1024] = { 0, };
        int decryptedSize = 0;

        ISSAC_PRIVATEKEY_Create(&priKey);

        // Ű б
        result = ISSAC_PRIVATEKEY_Read_Memory(&priKey, priKeyBytes, priKeyBytesLen, password);
        // Ű ޽ ȣȭ
        if (result == ISSAC_SUCCESS) {
            result = ISSAC_PE_Decrypt(decrypted, &decryptedSize, sizeof(decrypted), encrypted, encryptedSize, &priKey);
        }

        ISSAC_PRIVATEKEY_Delete(&priKey);
    }

    if (result == ISSAC_SUCCESS) {
        printf("[OK]\n");
        return 0;
    } else {
        printf("[ERROR] %s\n", ISSAC_GetErrorMessage(result));
        return 1;
    }
}

int main() {
    int result;

    result = sample_setup();
    if (result != 0) {
        return result;
    }

    return sample_pe_envelopeddata();
}
