#include <stdio.h>

#include "issacapi_pe.h"

/**
 * <pre>
 * ߱޴ : cn=׽Ʈ(-A),ou=RA,ou=TEST,ou=TEST߱޿,ou=licensedCA,o=KICA,c=KR
 * ߱   : cn=signGATE CA4,ou=AccreditedCA,o=KICA,c=KR
 * ȿⰣ : 2013/06/18 ~ 2014/07/11
 * Ű   : RSA 2048
 *  ˰ : sha256WithRSAEncryption
 * </pre>
 */
static const char *certB64 =
    "MIIFyjCCBLKgAwIBAgIEAlEqGjANBgkqhkiG9w0BAQsFADBKMQswCQYDVQQGEwJLUjENMAsGA1UECgwES0lDQTEVMBMGA1UECwwMQWNjcmVkaXRl"
    "ZENBMRUwEwYDVQQDDAxzaWduR0FURSBDQTQwHhcNMTMwNjE4MDQxOTUyWhcNMTQwNzExMTQ1OTU5WjCBkjELMAkGA1UEBhMCS1IxDTALBgNVBAoM"
    "BEtJQ0ExEzARBgNVBAsMCmxpY2Vuc2VkQ0ExFjAUBgNVBAsMDVRFU1TrsJzquInsmqkxFjAUBgNVBAsMDVRFU1Tsnbjspp3shJwxETAPBgNVBAsM"
    "CFJB7IS87YSwMRwwGgYDVQQDDBPthYzsiqTtirgo6rCc7J24LUEpMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAqMvo0a+XEcu46zBr"
    "ScFFstA9br1I/23/0rZAzbka9trkbavX/yU/WrqcR/OW1T3C9jzEc9wsJV6Holvy+5Nfrs0rT9dKLShv62dNOI4HNQuUJ82p8Mf9hE1aor/q65v7"
    "LFlhldSfqQwcmQHVkhE92T54gBYM3tiI14pTRxHXTCC9J0RgR73lyj2K9DCi3EHSFDWxQsrk7498r4bDXmCSLy8N+9cgp0ycf+a16cF2IgkD9fCp"
    "GB47MjD6YK6J4G/AlhrYeE3GgNFs2DcdoUXA2tu3RMEQtL/jUc7RkfrCYXVUeQzNs9yU+qkf9gE27FZoOLasTn+iRKLNI1BTxbMACQIDAQABo4IC"
    "bTCCAmkwgY8GA1UdIwSBhzCBhIAUrlL9Dg4B+DCGN372GMZJJUpgCXChaKRmMGQxCzAJBgNVBAYTAktSMQ0wCwYDVQQKDARLSVNBMS4wLAYDVQQL"
    "DCVLb3JlYSBDZXJ0aWZpY2F0aW9uIEF1dGhvcml0eSBDZW50cmFsMRYwFAYDVQQDDA1LSVNBIFJvb3RDQSA0ggIQCjAdBgNVHQ4EFgQUNwJ6J8tk"
    "JTw196s9SyXGLvK7hawwDgYDVR0PAQH/BAQDAgbAMHUGA1UdIARuMGwwagYKKoMajJpEBQIBAjBcMCwGCCsGAQUFBwIBFiBodHRwOi8vd3d3LnNp"
    "Z25nYXRlLmNvbS9jcHMuaHRtbDAsBggrBgEFBQcCAjAgHh7HdAAgx3jJncEcspQAIKz1x3jHeMmdwRzHhbLIsuQwgYgGA1UdEQSBgDB+gRNoeWNo"
    "dWxAc2lnbmdhdGUuY29toGcGCSqDGoyaRAoBAaBaMFgME+2FjOyKpO2KuCjqsJzsnbgtQSkwQTA/BgoqgxqMmkQKAQEBMDEwCwYJYIZIAWUDBAIB"
    "oCIEIF1OVexuxxa06/5bQkFRznWf2JV6UaEST0o8H2CX8BanMF4GA1UdHwRXMFUwU6BRoE+GTWxkYXA6Ly9sZGFwLnNpZ25nYXRlLmNvbTozODkv"
    "b3U9ZHA2cDk0NzQsb3U9Y3JsZHAsb3U9QWNjcmVkaXRlZENBLG89S0lDQSxjPUtSMEQGCCsGAQUFBwEBBDgwNjA0BggrBgEFBQcwAYYoaHR0cDov"
    "L29jc3Auc2lnbmdhdGUuY29tOjkwMjAvT0NTUFNlcnZlcjANBgkqhkiG9w0BAQsFAAOCAQEAHdOAJIjVc+ToFRb08LbciVZQVhxcqOE48gq98Q+2"
    "1bUH919MeRMnkENw362YHtpluRlLTWxquHVoGutB20ciHRMScdqCRShGQv+Nb2756ZmmOPsC1q+LFiImOlmv2wnyQir5zATktvwuiM4/aXWL6wA+"
    "P1hq2rw3IqUC4Idk21MJZY8EDa71AOwo2tUy/vodMLxqI5N48iuEyKles5TG/Iw5tWhh6qdOX4VF8QEsFY7kLdKoW8PnlFgjHt6vARtswfUTVI5X"
    "EaSlxjvQ6LCUJpGp5iwxJxzaXJ+kKQEGyVRTcucKlzTZ0mgJwk71DmZN1cfSqYtpmr0nM1X14hEAXA==";
static unsigned char certBytes[4096] = { 0, };
static int certBytesLen = 0;
static const char *priKeyB64 =
    "MIIFEDAaBggqgxqMmkQBDzAOBAjoS6syNypRxAICBAAEggTwPM2aWi0mIFieUG3EfeX2hJuQkS7mE/oPwwe8xpSvJrZBSU8Z1QZjKIsA5T+/2cR4"
    "9t/OWqqs8Gi0NFz9F2/MsErMUenVsSdfz+TrKtMpmY+vtzeaWcaKhjLI0jkUfQFjQC1/HE+JTBbPbWiTZbBppNslBpOvB8LwiQ6hhYRlsV7JQUrA"
    "+sRGeiwaWlPtZ4tv7XRC2L4qt9rzPLCywR4kbm9KwD20STCXZIOCthjCS0epoTlF9FB0JLurXY/1Oy+xsOJkH3j+6XVo7On6DIw+2VHBtOczhvvp"
    "b79htB3kcPfr02bHZ0QeypMmYLthjUlBBqRgciX7O8jUbAcKUTlojrQh/8KaK8qUkLt8WoNmtLQGoq0h8jeFqdGjSHafSP25kyKFQv3AM0hIQd1n"
    "ZmVlDJyMyVDz8EriFXolyKVg0YagEKG8sRDA79Kn/ftHskriZyEldM1/8hgCTtbWnBbTuZsWDMIrO1Z16CtpYTVmFkE0Ix1n4J3uJtHJJsT63WpY"
    "KzRMAQBg1w0PFQ4IisnJbLS4G7pxmkENaQT8or6jOb1e+G/qyU0rTK4H7+oab5g7XyaJp8NxH8a+cGSFqBK3RPTWHt9YUpGpv9y0v+WpgorQLMA1"
    "v/qIoBxg3mp9zs0kKjAHvOGySQ/vZ8ave9611LTfWoaHde8BVCCCoaNYdAKM6642zqEcpXAsp0JB6YqCzgm0UskuLbZ4LXg9zcFSO+jmHhTp6DPo"
    "xvCrh3M3NNaOpoM/MLofbL43MDmfkTe9RQBdssRCGV6quGvjVDuZt98b/nYVcF10+PTY9YnYwLzW3/V87L/O+4AoHqVGCt4xPBWjMgBCjyvdVZYw"
    "MzdwaFZvb/DWr2Y8zu6g0kWcELOATrjhYOKfysYO7qn/rSvXBE4/IvwnBA4gKTPjwePQ18uDQmlURbsgnAuMzKdnafFgQyE/48FC//mL9PisfBLO"
    "sVucdMpelCdzvzXxeMphjA3mQo4P/QD/LMqvVtgoGhNPPhthqz5eEq8iGyZm6sxoA9wJeyt7EGEWlsgttvV1zJiXsHiejZtiJaGWiU2jjX3qhJhb"
    "TIarsphm/bRUkWBzy8qxHIo3AMsBcMIX0Mvch0BQ6Uvd/fK81I2KmuAPM4KNilQqVQRwYaczC5Syhj84zTPGLFCTXLwTShJDI5m7jquaazylZ0iW"
    "zzl1T17EjvSARUZ6I5i4Uubvo7t7qxJC47gHVrlW9bk2oqKrej8A7IZ7lHElZaZv3eo+8gi1SAX+bOfXLJNd3MhUKYPPmd/jYDpA3wkpb3ZU3kP0"
    "kAqfAocJ/KQIDrPjpdgzMrBRylKZWseyPha3W8Fffk+woYlD1jsiZZ6dROqw1YkLJ/nWaDT9/6W0T6oTSz9X1zEhD5ov2bkHV8WZmmZ5Ll7cBoqp"
    "q6yyfVZclEZu8y1WiMvHnruTABLaW+I9yo81Y3o3QC2bssfvftKWd21joV22yUB6lhBnBeTm2vyDjunHdPabO0BdzfjQvpA0M7cMCXZC3JSntctS"
    "fCmvnnxVamkiuCpB8zQaP836jw1S1YslSSZfdeb85vgoFb21UDfu+aeezPJ3oVxN+isYlhptTls0IadyTUslyN6rveIrZzTOSVwsaBZspnHJm4Bp"
    "cBWODaQ7iaqX0r1NbfDTlYpkRVeaQ8htR396alvaO0KjcPaVuMO5VA==";
static unsigned char priKeyBytes[2048] = { 0, };
static int priKeyBytesLen = 0;
static const char *password = "a123456A";

/**
 * <pre>
 * ߱޴ : cn=̴ذ(IniPer)200080120190311900000003,ou=INIPASS2000,ou=personal,o=INIPASS,c=KR
 * ߱   : cn=INIPASS CA,ou=AccreditedCA,o=INIPASS,c=KR
 * ȿⰣ : 2019/03/11 ~ 2019/06/09
 * Ű   : RSA 2048
 *  ˰ : sha256WithRSAEncryption
 * </pre>
 */
static const char *otherCertB64 =
    "MIIFszCCBJugAwIBAgICAZkwDQYJKoZIhvcNAQELBQAwSzELMAkGA1UEBhMCS1IxEDAOBgNVBAoMB0lOSVBBU1MxFTATBgNVBAsMDEFjY3JlZGl0"
    "ZWRDQTETMBEGA1UEAwwKSU5JUEFTUyBDQTAeFw0xOTAzMTEwNTA0NTlaFw0xOTA2MDkxNDU5NTlaMIGCMQswCQYDVQQGEwJLUjEQMA4GA1UECgwH"
    "SU5JUEFTUzERMA8GA1UECwwIcGVyc29uYWwxFDASBgNVBAsMC0lOSVBBU1MyMDAwMTgwNgYDVQQDDC/snbTri4jthY3qsJzsnbgoSW5pUGVyKTIw"
    "MDA4MDEyMDE5MDMxMTkwMDAwMDAwMzCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAIrdG5fdGmTME6FpzwbFb5HBRojBKfbsSrpyiHlq"
    "n1uKBaaajoBsYIeNbOwg7roLkQvm0uodET4G3MWRJaAGGOtbIKffFd7nPo1oELinQvF2Gcr2siwgSI7YbvAnPI5s11Dc4D86NqS/b+tC/zSNuLUX"
    "bBKVoxUHG4E7IEEcK1zF5LLalvPFFwVhLx/IsylCvkHWw900jKGeBgBsFDklRDdSFI/jwiMnJgMtGYFxakXh6pMgzof4DQNCsA/8beHQ37iBXKoA"
    "380/tB3TFDJA2AB0KuOQDeFbvRLaiyqx7UNcWM6AM7ubcrj4B2XoS6zPTo85Dx6iQTaLPkwEQ6ilXDECAwEAAaOCAmcwggJjMIGPBgNVHSMEgYcw"
    "gYSAFKORisOXVoYiGgulHJtUsiz4oqcFoWikZjBkMQswCQYDVQQGEwJLUjENMAsGA1UECgwES0lTQTEuMCwGA1UECwwlS29yZWEgQ2VydGlmaWNh"
    "dGlvbiBBdXRob3JpdHkgQ2VudHJhbDEWMBQGA1UEAwwNS0lTQSBSb290Q0EgNIICECQwHQYDVR0OBBYEFFIslyxQUQ9/Bdlkw+0AiXaD150XMA4G"
    "A1UdDwEB/wQEAwIGwDB8BgNVHSABAf8EcjBwMG4GCiqDGoyaRAUFAQEwYDAuBggrBgEFBQcCARYiaHR0cDovL3d3dy5pbmlwYXNzLmNvbS9tYS9Q"
    "T18wNC5hZzAuBggrBgEFBQcCAjAiHiDHdAAgx3jJncEcspQAIKz1x3jHeMmdwRwAIMeFssiy5DBuBgNVHREEZzBloGMGCSqDGoyaRAoBAaBWMFQM"
    "D+ydtOuLiO2FjeqwnOyduDBBMD8GCiqDGoyaRAoBAQEwMTALBglghkgBZQMEAgGgIgQgeIkP8+qhOB5hQLxSg2CoENfDcrxKlJG9Fskt3RRSt4ow"
    "dwYDVR0fBHAwbjBsoGqgaIZmbGRhcDovL2Rpci5pbmlwYXNzLmNvbTozODkvb3U9ZHA4MXAxLG91PWNybGRwLG91PUFjY3JlZGl0ZWRDQSxvPUlO"
    "SVBBU1MsYz1rcj9jZXJ0aWZpY2F0ZVJldm9jYXRpb25MaXN0MDkGCCsGAQUFBwEBBC0wKzApBggrBgEFBQcwAYYdaHR0cDovL29jc3AuaW5pcGFz"
    "cy5jb206NDYxMi8wDQYJKoZIhvcNAQELBQADggEBADouu5wh+r1t0+elJZAScMwIBUNRcG/41aV6M9mjXVHTPj+874IeOqghlvVPdiRPGQl6RdXy"
    "E+QtVa2VM2yTgQjB0WP8iVRJmcHGj5oH2X1HV6Og0FhmgL+BNflrEzTuvu3FnYUgCynDGCNTl26beP2CVXUVcPiGasKSwxIoya8RtybzTQD1gZLv"
    "ZDEXqAGeYFKPNU+V4mTolDaB7+P+W98cGD47ai4efy0e4id8x6cl9eAMA7rCkshylxZnuPk6lOflR1SsRgAyzcT288yRuViEc/rKGGhrYz9fJGuS"
    "5Sz0PUTKzkxxn3/BPOhvRdgKSRBMX4ZGFqgiynj6qbZBqnQ=";
unsigned char otherCertBytes[4096] = { 0, };
int otherCertBytesLen = 0;
static const char *otherPriKeyB64 =
    "MIIFEDAaBggqgxqMmkQBDzAOBAg0ThZK2Xze5gICCAAEggTw5gK4W3R5WZIHGfvDlATewr8N18VcvqPpO8ruIXHSQBeJpUvTiVZMU+2AJfkTGzXZ"
    "xLfd+oUF+uzBPm2MV5xPVQsDr6ktFsTrqSUe+gunx9M9XH9UHPPj6xqwdsv0JJLTAQx/vi+Cd3AP0rYmxMvamUfXk7UQvsGI32Wj0P1WJ1bkgRNm"
    "IO+uMGKH/bp78W20L4CyhhxrlaAeZT0uVE6HvVxONHKxbmq8BDKKrWp5QIcihQhXgvjxtH7UjwQaOqZZOBZn4eN6aZZahn20jCJqoSGYUSGzGHaT"
    "HcOTnQqxLJIo0n043nUKPglVU58uNPUjEy17hhoWs/r4unfVmQqpaIChJjQNKy82MptXvtyPCtyf/bvHBA8PL7oDfZy+UNtQIXGZW+jFMTr5DMQ2"
    "6LwzyHg8BD5dlSl5Yw6UtpwrmL06fso7vBbZc7gV2QRFaFCH734/UJ3ig41/yEPGUvEwlB9y3xNeTaNQPA+9AZfnSaRHX93Z5iOf2VU7Q9YcIRp4"
    "RRC6K6kENNNGszAaFlSqNMN5rWuF0/9xX7gYF7sqqdlAAClAZMM/JUdD5SOS412AyKJHuIpC4pngF65AebihkjjJxL86+h1qZ2wGq2e07hY16l2r"
    "YsU8zpUrJNBYaH01xIRm9+zJHXUbLxD9moNGAAQcSfE1EDhykTmWL9FNtf+94xsDfLAdIB9OXt9hQBBYHm44iWxmqz35C23SPBba6zZAobjFt9mv"
    "nPpFLJ6nGRdojKvxUhk+zd4UPYpMXvdHx9m4XlPTUcdSzjXx7cjsxeRaAYSUPm/M1fBOhnisRII13r/z5HhKM3jt11XW1670DKv2+lPinE28iOOE"
    "qpVH5ja4rRb8JCYLaWu6QchM+5g3ALBUC5K10RJ80RthgHsDOeQS7tSJPALZGQYB8X92LGm+AypvC6DIIJMBWv0QxTPpY7aLoNZ1OIjzRiQX/vaz"
    "IhCo8uPGMbhictVxSXxD1pMnkApDcdU628xoTeZwcfzx2j2MaDQPwefmxKANhJqx+rLtLyNqocjUm5FadwNKfp8Yrk+gMQ3v1KvO+LuFtq8BcQXw"
    "EkbrYv2byX793kqvdDa4Q7DgMc4c47UtiDVmBEmfNWFiSj0Y8K6VFcxCLg5NnD84L91/kDrTMK2vp3Oqm9yaVCz6I7ljhjfxfwf/DfUjvgmajYjH"
    "WZ40dGL+NxLPWwajwTZ3Ed7StNzj/sKFL1lH3fDH/99i4duVIrfQntVqZATpo3pQ6EaWj/HBInFpsXthcXGC3kMZt2aPDn8hKp13ypb8Tp4EYd9w"
    "v7uTgbK/InjgvjNYq/6NjxqOd1YFK1u0+w0r0cIMKeoGMhbBpsRKNamhDfBlekewk5mBioQzlOZRStZakUDdhzj3YtQdPSrR4TYqnVIFp7ylh+Jz"
    "D11Sj5NmgmMWwYhwuw2ceh2Rg+qU/C2pDw1loRd+G6XE6Pv2+YOnCGk+ne8Wg92fSSCNkcHmai3JyWTjT1RQSfWUHGHfaKQUKkm3E0p8JdMCaJt7"
    "9wJYIJF5LnCFqUlVEOQbjB0F3eVaw7YpzKd/layjwRT6TvXVFMknFtYaVGKPEZGHf/FXCVOR9IPYY6riPDwhNCHz6/n0h2v2MZ0wdch8q43V/rMP"
    "s8OvwMFhUyxevCtxajQsdIF2lM4yAUJrZgFP5OuJ1ycfF1z/vRsl5g==";
unsigned char otherPriKeyBytes[2048] = { 0, };
int otherPriKeyBytesLen = 0;
const char *otherPassword = "Inipass@2019";

static const unsigned char *plaintext = (const unsigned char *) "This is a test text";
static int plaintextSize = 19; // strlen("This is a test text");

static int sample_setup() {
    ISSAC_RETURN result;

    result = ISSAC_Initialize();
    if (result != ISSAC_SUCCESS) {
        printf("[ERROR] %s\n", ISSAC_GetErrorMessage(result));
        return 1;
    }
    result = ISSAC_BASE64_Decode(certBytes, &certBytesLen, sizeof(certBytes), certB64);
    if (result != ISSAC_SUCCESS) {
        printf("[ERROR] %s\n", ISSAC_GetErrorMessage(result));
        return 1;
    }
    result = ISSAC_BASE64_Decode(priKeyBytes, &priKeyBytesLen, sizeof(priKeyBytes), priKeyB64);
    if (result != ISSAC_SUCCESS) {
        printf("[ERROR] %s\n", ISSAC_GetErrorMessage(result));
        return 1;
    }
    result = ISSAC_BASE64_Decode(otherCertBytes, &otherCertBytesLen, sizeof(otherCertBytes), otherCertB64);
    if (result != ISSAC_SUCCESS) {
        printf("[ERROR] %s\n", ISSAC_GetErrorMessage(result));
        return 1;
    }
    return 0;
}

static int sample_pe_envelopeddata_multi() {
    ISSAC_RETURN result;
    char encrypted[4096] = { 0, };
    int encryptedSize = 0;

    printf("sample_pe_envelopeddata_multi() => ");

    // ȣȭ
    {
        CERTIFICATES certs;
        CERTIFICATE cert;
        CERTIFICATE otherCert;
        
        ISSAC_CERTIFICATES_Create(&certs);
        ISSAC_CERTIFICATE_Create(&cert);
        ISSAC_CERTIFICATE_Create(&otherCert);

        //  б
        result = ISSAC_CERTIFICATE_Read_Memory(&cert, certBytes, certBytesLen);
        if (result == ISSAC_SUCCESS) {
            result = ISSAC_CERTIFICATE_Read_Memory(&otherCert, otherCertBytes, otherCertBytesLen);
        }

        //    ߰ϱ
        if (result == ISSAC_SUCCESS) {
            result = ISSAC_CERTIFICATES_AddCertificate(&certs, &cert);
        }
        if (result == ISSAC_SUCCESS) {
            result = ISSAC_CERTIFICATES_AddCertificate(&certs, &otherCert);
        }

        //  ڵ  ޽ ȣȭ
        if (result == ISSAC_SUCCESS) {
            result = ISSAC_PE_EncryptEx(encrypted, &encryptedSize, sizeof(encrypted), plaintext, plaintextSize, &certs, ISSACAPI_SEED);
        }

        ISSAC_CERTIFICATES_Delete(&certs);
        ISSAC_CERTIFICATE_Delete(&cert);
        ISSAC_CERTIFICATE_Delete(&otherCert);
    }

    // ȣȭ
    if (result == ISSAC_SUCCESS) {
        CERTIFICATE cert;
        PRIVATEKEY priKey;
        char decrypted[1024] = { 0, };
        int decryptedSize = 0;

        ISSAC_CERTIFICATE_Create(&cert);
        ISSAC_PRIVATEKEY_Create(&priKey);

        //   б ( Ȯ  ʿ)
        result = ISSAC_CERTIFICATE_Read_Memory(&cert, certBytes, certBytesLen);
        // Ű б
        if (result == ISSAC_SUCCESS) {
            result = ISSAC_PRIVATEKEY_Read_Memory(&priKey, priKeyBytes, priKeyBytesLen, password);
        }
        // Ű ޽ ȣȭ
        if (result == ISSAC_SUCCESS) {
            result = ISSAC_PE_DecryptEx(decrypted, &decryptedSize, sizeof(decrypted), encrypted, encryptedSize, &cert, &priKey);
        }

        ISSAC_CERTIFICATE_Delete(&cert);
        ISSAC_PRIVATEKEY_Delete(&priKey);
    }

    if (result == ISSAC_SUCCESS) {
        printf("[OK]\n");
        return 0;
    } else {
        printf("[ERROR] %s\n", ISSAC_GetErrorMessage(result));
        return 1;
    }
}

int main() {
    int result;

    result = sample_setup();
    if (result != 0) {
        return result;
    }

    return sample_pe_envelopeddata_multi();
}
