#include <stdio.h>

#include "issacapi_pe.h"

static const char *pubKeyB64 =
    "MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA4YmqkImqA+c4UGtQC3aZV+dCtE5fXlMoaASysBFr9ok4XcHvcRRqXUxDtrqQWhHks6oJ"
    "XfKHQg9dvDPy7Gj5uIg23r/BIu94gFIW+BaOUNy5/pM+G+cAAA6FrUdRivByfsHLfQJ5sjuzxEqvngfnknRzeY+kPtnFepj+/1uhh5frT6DLr2tx"
    "tc+sX6WTqmW0Ez/z8x6A1fU5yriQUVxgQvutPx896eIzJmfw/gIWAGGVK8uJmNgUwsF5BCrW90fnQhkrSUUvfr6DVUwAQHn7+h5YUlw8trV+BUpV"
    "0HllVFr/BaFRAMMp75yz7JZH+0wJiKGitUcFWkWPZ1wqsv0ruQIDAQAB";
static unsigned char pubKeyBytes[2048] = { 0, };
static int pubKeyBytesLen = 0;

static const char *priKeyB64 =
    "MIIEvQIBADANBgkqhkiG9w0BAQEFAASCBKcwggSjAgEAAoIBAQDhiaqQiaoD5zhQa1ALdplX50K0Tl9eUyhoBLKwEWv2iThdwe9xFGpdTEO2upBa"
    "EeSzqgld8odCD128M/LsaPm4iDbev8Ei73iAUhb4Fo5Q3Ln+kz4b5wAADoWtR1GK8HJ+wct9AnmyO7PESq+eB+eSdHN5j6Q+2cV6mP7/W6GHl+tP"
    "oMuva3G1z6xfpZOqZbQTP/PzHoDV9TnKuJBRXGBC+60/Hz3p4jMmZ/D+AhYAYZUry4mY2BTCwXkEKtb3R+dCGStJRS9+voNVTABAefv6HlhSXDy2"
    "tX4FSlXQeWVUWv8FoVEAwynvnLPslkf7TAmIoaK1RwVaRY9nXCqy/Su5AgMBAAECggEAAlPhxiPblLZ7UO4omXOwBbWZ7UM1TgOI8ljhELrfTMAy"
    "DBqrKlU5+0xFEyLWCE3wuK93sQfmoDaJIr79AfZb5G0IdvBO8Zm72kQun0EZVymOBFv360ENMZL0y3rl0yuj3N3KaDgBMkcWNf+I1DZT7CGmSvIB"
    "8ZGdDYS8df13u27fnH+4dnP8ZccpNHCG3rSBAqeaWIHkGaUZ/Jk3Y2o28G9wt51bbm5ycD9GI3k5AzV0+PZq8AiZIj4+5tBrEp57QwNndJA7Hx92"
    "Q559iRcJTdlzHitRxo/C+WQRpm/EIV/1SpElbHgVUfOc454Ys98DonhdreF2dOI/ILjROLMBkQKBgQD7LZplvSChWaniXjRKtFkQDO0GFOFWcLXp"
    "odlQ92T6NQ/DJF4J+KnkF5qtasgjJvQ5IscFTlQ2t81uvQ8/iOpIhVDmwdR/ItJrQbKKP1pEXtuT4A7nWFOFP7Sm3uYK8Hd3qoo7EP6D4XtDUDUJ"
    "EP1wcPjWapekFt1iGKETWLWXMQKBgQDl3g4r+Ncx6Phsn3fi0s2Wk1zRJ+g/uBty56XdOdm+Fz133/dbSlpHssvLEykcdi4hcoP2kM5Fhla5Nhi/"
    "lYTKmMNb9ddIqUqd76QweVyBMdmzs2Dk0D8K7chioP1B1GiBJgfnAfryZulXix3lRenq/mUiTfFwvqt/Bo4SkWfLCQKBgQDu6eyfcyrTbpcB43s3"
    "x52jf7gAfeHst57A0JsFwZvBxrDse+4a6/SlKbKN2zDtBsNsiWDm8h92QJReDeSwGUpHms9d/uZh27xsGvx5NVNmDxgq6wciFEi1SOhLhV8o7puk"
    "Lon3Lu34gYQefe9EZW28AykdwhvlD36aLTUhUtK/MQKBgGu5YdjXmDnqnSmCnlNtSS2sx825Lw1VgX+a8c84QkPkbkkUa76bnK2HLBxyUUzmUX4Z"
    "RaCygghxCYlowbZfIskzSDJ7hrWlqLNVUBPrfB+LtiOSB/GTakf74XHfUnCcU5Fauk9XTTx2YBpHtu3wkswvBkRKVMDqikJQVxp6jDLJAoGABO7T"
    "bInfGzmJgecmJaW+GqnMhJ/n8ajNFZoS9jRZpDCWXUujhkmsnJfXuKyFi4RLKVPeSu0wGy4977IzCJ4rzKrO4q0uxbm82l7rvw2EkjEm4TSF6ZMb"
    "q5Om5IRRs2CNy28FRPI1vz8+giyBOyFBYEi4Gjbno58ZcPgWETKnrt4=";
static unsigned char priKeyBytes[2048] = { 0, };
static int priKeyBytesLen = 0;

static const unsigned char *plaintext = (const unsigned char *) "This is a test text";
static int plaintextSize = 19; // strlen("This is a test text");

static int sample_setup() {
    ISSAC_RETURN result;

    result = ISSAC_Initialize();
    if (result != ISSAC_SUCCESS) {
        printf("[ERROR] %s\n", ISSAC_GetErrorMessage(result));
        return 1;
    }
    result = ISSAC_BASE64_Decode(pubKeyBytes, &pubKeyBytesLen, sizeof(pubKeyBytes), pubKeyB64);
    if (result != ISSAC_SUCCESS) {
        printf("[ERROR] %s\n", ISSAC_GetErrorMessage(result));
        return 1;
    }
    result = ISSAC_BASE64_Decode(priKeyBytes, &priKeyBytesLen, sizeof(priKeyBytes), priKeyB64);
    if (result != ISSAC_SUCCESS) {
        printf("[ERROR] %s\n", ISSAC_GetErrorMessage(result));
        return 1;
    }
    return 0;
}

static int sample_pe_rawbytes() {
    ISSAC_RETURN result;
    char encrypted[1024] = { 0, };
    int encryptedSize = 0;

    printf("sample_pe_rawbytes() => ");

    // ȣȭ
    {
        PUBLICKEY pubKey;
        
        ISSAC_PUBLICKEY_Create(&pubKey);

        // Ű б
        result = ISSAC_PUBLICKEY_Read_Memory(&pubKey, pubKeyBytes, pubKeyBytesLen);
        // Ű ޽ ȣȭ
        if (result == ISSAC_SUCCESS) {
            result = ISSAC_RSA15_RSAES_Encrypt(encrypted, &encryptedSize, plaintext, plaintextSize, &pubKey);
        }

        ISSAC_PUBLICKEY_Delete(&pubKey);
    }

    // ȣȭ
    if (result == ISSAC_SUCCESS) {
        PRIVATEKEY priKey;
        char decrypted[1024] = { 0, };
        int decryptedSize = 0;

        ISSAC_PRIVATEKEY_Create(&priKey);

        // Ű б
        result = ISSAC_PRIVATEKEY_Read_Memory(&priKey, priKeyBytes, priKeyBytesLen, NULL);
        // Ű ޽ ȣȭ
        if (result == ISSAC_SUCCESS) {
            result = ISSAC_RSA15_RSAES_Decrypt(decrypted, &decryptedSize, encrypted, encryptedSize, &priKey);
        }

        ISSAC_PRIVATEKEY_Delete(&priKey);
    }

    if (result == ISSAC_SUCCESS) {
        printf("[OK]\n");
        return 0;
    } else {
        printf("[ERROR] %s\n", ISSAC_GetErrorMessage(result));
        return 1;
    }
}

int main() {
    int result;

    result = sample_setup();
    if (result != 0) {
        return result;
    }

    return sample_pe_rawbytes();
}
