#include <stdio.h>

#include "issacapi_pfx.h"
#include "issacapi_errorcode.h"

static const char *pfxB64 = "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";
static unsigned char pfxBytes[14837] = { 0, };
static int pfxBytesLen = 0;
static const char *pfxPassword = "a123456A";
static const char *priKeyPassword = "a123456A";


static int sample_setup() {
    ISSAC_RETURN result;

    result = ISSAC_Initialize();
    if (result != ISSAC_SUCCESS) {
        printf("[ERROR] %s\n", ISSAC_GetErrorMessage(result));
        return 1;
    }
    result = ISSAC_BASE64_Decode(pfxBytes, &pfxBytesLen, sizeof(pfxBytes), pfxB64);
    if (result != ISSAC_SUCCESS) {
        printf("[ERROR] %s\n", ISSAC_GetErrorMessage(result));
        return 1;
    }
    return 0;
}

static int sample_pfx_decode() {
    ISSAC_RETURN result;
    PFX_CONTEXT pfx;

    // PFX ó ſ  ۾̱ ,   .
    // PFX ƴ  뵵 ° Ͽ Ѵ.

    printf("sample_pfx_decode() => ");

    ISSAC_PFX_Create(&pfx);

    result = ISSAC_PFX_Decode(&pfx, pfxBytes, pfxBytesLen, pfxPassword);

    //  Ű 
    if (result == ISSAC_SUCCESS) {
        int bagIndex;
        for (bagIndex = 0; bagIndex < pfx.count; bagIndex++) {
            ISSACAPI_BAGTYPE bagType;
            result = ISSAC_PFX_GetBagType(&bagType, &pfx, bagIndex);
            if (result == ISSAC_SUCCESS) {
                if (bagType == ISSACAPI_BAGTYPE_CERT) {
                    // 
                    CERTIFICATE cert;
                    ISSAC_CERTIFICATE_Create(&cert);
                    result = ISSAC_PFX_GetCertificate(&cert, &pfx, NULL, 0);
                    ISSAC_CERTIFICATE_Delete(&cert);
                } else if (bagType == ISSACAPI_BAGTYPE_KEY) {
                    // Ű (PKCS#8)
                    PRIVATEKEY priKey;
                    ISSAC_PRIVATEKEY_Create(&priKey);
                    result = ISSAC_PFX_GetPrivateKey(&priKey, &pfx, NULL, 0, NULL);
                    ISSAC_PRIVATEKEY_Delete(&priKey);
                } else if (bagType == ISSACAPI_BAGTYPE_KEY_ENCRYPTED) {
                    // ȣȭ  Ű (PKCS#8)
                    PRIVATEKEY priKey;
                    ISSAC_PRIVATEKEY_Create(&priKey);
                    result = ISSAC_PFX_GetPrivateKey(&priKey, &pfx, NULL, 0, priKeyPassword);
                    ISSAC_PRIVATEKEY_Delete(&priKey);
                }
            }
            if (result != ISSAC_SUCCESS) {
                break;
            }
        }
    }

    // Űֿ ° 
    if (result == ISSAC_SUCCESS) {
        int bagIndex;
        for (bagIndex = 0; bagIndex < pfx.count; bagIndex++) {
            ISSACAPI_BAGTYPE bagType;
            result = ISSAC_PFX_GetBagType(&bagType, &pfx, bagIndex);
            if (result == ISSAC_SUCCESS && bagType == ISSACAPI_BAGTYPE_CERT) {
                // Ű ϴ SafeBag  2̹Ƿ,  ÿ  쿡 Ű  óϵ Ͽ.
                unsigned char localKeyId[64] = { 0, };
                int localKeyIdSize = 0;
                if (ISSAC_PFX_GetLocalKeyID(localKeyId, &localKeyIdSize, sizeof(localKeyId), &pfx, bagIndex) == ISSAC_SUCCESS) {
                    // Ű  , localKeyId  ̿Ͽ Ű Ѵ.
                    CERTIFICATE cert;
                    PRIVATEKEY priKey;
                    ISSAC_CERTIFICATE_Create(&cert);
                    ISSAC_PRIVATEKEY_Create(&priKey);
                    result = ISSAC_PFX_GetCertificateAndPrivateKey(&cert, &priKey, &pfx, localKeyId, localKeyIdSize, priKeyPassword);
                    ISSAC_CERTIFICATE_Delete(&cert);
                    ISSAC_PRIVATEKEY_Delete(&priKey);
                }
            }
            if (result != ISSAC_SUCCESS) {
                break;
            }
        }
    }

    //  Ʈ  (Ű ġϴ Ű Ե  )
    if (result == ISSAC_SUCCESS) {
        CERTIFICATES certs;
        ISSAC_CERTIFICATES_Create(&certs);
        result = ISSAC_PFX_GetOtherCertificates(&certs, &pfx);
        ISSAC_CERTIFICATES_Delete(&certs);
    }

    ISSAC_PFX_Delete(&pfx);

    if (result == ISSAC_SUCCESS) {
        printf("[OK]\n");
        return 0;
    } else {
        printf("[ERROR] %s\n", ISSAC_GetErrorMessage(result));
        return 1;
    }
}

int main() {
    int result;

    result = sample_setup();
    if (result != 0) {
        return result;
    }

    return sample_pfx_decode();
}
