#include <stdio.h>

#include "issacapi_bs.h"
#include "issacapi_se.h"
#include "issacapi_errorcode.h"


static const unsigned char *plaintext = (const unsigned char *) "This is a test text";
static int plaintextSize = 19; // strlen("This is a test text");
static const char *authdata = "This is a authentication message";
static int authdataSize = 32; // strlen("This is a authentication message");
static const unsigned char symm_key[] = {
    0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08,
    0x09, 0x0A, 0x0B, 0x0C, 0x0D, 0x0E, 0x0F, 0x10
};
static const unsigned char iv[] = {
    0x08, 0x18, 0x28, 0x38, 0x48, 0x58, 0x68, 0x78,
    0x88, 0x98, 0xA8, 0xB8, 0xC8, 0xD8, 0xE8, 0xF8 
};

static int sample_setup() {
    EErrorCode result = wasdk_init();
    if (result != EEC_Success) {
        printf("[ERROR] %s\n", wasdk_error_message(result));
        return 1;
    }
    return 0;
}

int sample_se_gcm() {
    ISSAC_RETURN result;
    unsigned char encrypted[32] = { 0, };
    int encryptedSize = 0;
    int tagSize = 4;

    printf("sample_se_gcm() => ");

    // encrypt
    {
        SECONTEXT encipher;
        ISSAC_SECONTEXT_Create(&encipher);
        result = ISSAC_SECONTEXT_Set(&encipher, symm_key, sizeof(symm_key), NULL, 0, ISSACAPI_SE_GCM_MODE, ISSACAPI_SEED);
        if (result == ISSAC_SUCCESS) {
            result = ISSAC_SE_Encrypt_Auth(encrypted, &encryptedSize, sizeof(encrypted), (void *) plaintext, plaintextSize,
                    (void *) authdata, authdataSize, (void *) iv, sizeof(iv), tagSize, &encipher);
        }
        ISSAC_SECONTEXT_Delete(&encipher);
    }
    // decrypt
    if (result == ISSAC_SUCCESS) {
        SECONTEXT decipher;
        unsigned char decrypted[32] = { 0, };
        int decryptedSize = 0;
        ISSAC_SECONTEXT_Create(&decipher);
        result = ISSAC_SECONTEXT_Set(&decipher, symm_key, sizeof(symm_key), NULL, 0, ISSACAPI_SE_GCM_MODE, ISSACAPI_SEED);
        if (result == ISSAC_SUCCESS) {
            result = ISSAC_SE_Decrypt_Auth(decrypted, &decryptedSize, sizeof(decrypted), (void *) encrypted, encryptedSize,
                    (void *) authdata, authdataSize, (void *) iv, sizeof(iv), tagSize, &decipher);
        }
        ISSAC_SECONTEXT_Delete(&decipher);
    }

    if (result == ISSAC_SUCCESS) {
        printf("[OK]\n");
        return 0;
    } else {
        printf("[ERROR] %s\n", ISSAC_GetErrorMessage(result));
        return 1;
    }
}

int main() {
    int result;

    result = sample_setup();
    if (result != 0) {
        return result;
    }

    return sample_se_gcm();
}
