#include <stdio.h>

#include "issacapi_bs.h"
#include "issacapi_se.h"
#include "issacapi_errorcode.h"


static const unsigned char *plaintext = (const unsigned char *) "This is a test text";
static int plaintextSize = 19; // strlen("This is a test text");
static const unsigned char symm_key[] = {
    0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08,
    0x09, 0x0A, 0x0B, 0x0C, 0x0D, 0x0E, 0x0F, 0x10
};

static int sample_setup() {
    EErrorCode result = wasdk_init();
    if (result != EEC_Success) {
        printf("[ERROR] %s\n", wasdk_error_message(result));
        return 1;
    }
    return 0;
}

int sample_se_seed() {
    ISSAC_RETURN result;
    unsigned char encrypted[32] = { 0, };
    int encryptedSize = 0;

    printf("sample_se_seed() => ");

    // encrypt
    {
        SECONTEXT encipher;
        ISSAC_SECONTEXT_Create(&encipher);
        result = ISSAC_SECONTEXT_Set(&encipher, symm_key, sizeof(symm_key), NULL, 0, ISSACAPI_SE_CBC_MODE, ISSACAPI_SEED);
        if (result == ISSAC_SUCCESS) {
            result = ISSAC_SE_Encrypt(encrypted, &encryptedSize, sizeof(encrypted), (void *) plaintext, plaintextSize, &encipher);
        }
        ISSAC_SECONTEXT_Delete(&encipher);
    }
    // decrypt
    if (result == ISSAC_SUCCESS) {
        SECONTEXT decipher;
        unsigned char decrypted[32] = { 0, };
        int decryptedSize = 0;
        ISSAC_SECONTEXT_Create(&decipher);
        result = ISSAC_SECONTEXT_Set(&decipher, symm_key, sizeof(symm_key), NULL, 0, ISSACAPI_SE_CBC_MODE, ISSACAPI_SEED);
        if (result == ISSAC_SUCCESS) {
            result = ISSAC_SE_Decrypt(decrypted, &decryptedSize, sizeof(decrypted), (void *) encrypted, encryptedSize, &decipher);
        }
        ISSAC_SECONTEXT_Delete(&decipher);
    }

    if (result == ISSAC_SUCCESS) {
        printf("[OK]\n");
        return 0;
    } else {
        printf("[ERROR] %s\n", ISSAC_GetErrorMessage(result));
        return 1;
    }
}

int main() {
    int result;

    result = sample_setup();
    if (result != 0) {
        return result;
    }

    return sample_se_seed();
}
