#include <stdio.h>

#include "issacapi_bs.h"
#include "issacapi_sg.h"
#include "issacapi_errorcode.h"

/**
 * <pre>
 * ߱޴ : cn=ECDSA_secp192r1,ou=PKI,o=PENTA,c=KR
 * ߱ : cn=ECCCA,ou=PKI,o=PENTA,c=KR
 * ȿⰣ : 2017/07/20 ~ 2018/07/20
 * Ű : EC - secp192r1
 *  ˰ : ecdsa-with-SHA256
 * CRL  : ldap://10.0.81.5:389/cn=dp_k_-oCDP4QO-iqf_DAEd3igp0,ou=PKI,o=PENTA,c=KR
 * </pre>
 */
static const char *certB64 =
    "MIICZzCCAh6gAwIBAgIGAOjUpRACMAoGCCqGSM49BAMCMDsxCzAJBgNVBAYTAktSMQ4wDAYDVQQKDAVQRU5UQTEMMAoGA1UECwwDUEtJMQ4wDAYD"
    "VQQDDAVFQ0NDQTAeFw0xNzA3MTkxNTAwMDBaFw0xODA3MjAxNDU5NTlaMEUxCzAJBgNVBAYTAktSMQ4wDAYDVQQKDAVQRU5UQTEMMAoGA1UECwwD"
    "UEtJMRgwFgYDVQQDDA9FQ0RTQV9zZWNwMTkycjEwSTATBgcqhkjOPQIBBggqhkjOPQMBAQMyAAQwfngoTe35z/5fShA3saeGqfrcDi0NF9wr8b5b"
    "3DJGXhVObNFqLrh8IadKOR6kjR6jggESMIIBDjBkBgNVHSMEXTBbgBT0gEWgUNnasgeM2CjTJuYtHHkiFaFApD4wPDELMAkGA1UEBhMCS1IxDjAM"
    "BgNVBAoMBVBFTlRBMQwwCgYDVQQLDANQS0kxDzANBgNVBAMMBkVDQ1JDQYIBAjAdBgNVHQ4EFgQU++yqycDRrNEZTorCL1OUCGWyGZYwDgYDVR0P"
    "AQH/BAQDAgPoMB0GA1UdJQQWMBQGCCsGAQUFBwMBBggrBgEFBQcDAjBYBgNVHR8EUTBPME2gS6BJhkdsZGFwOi8vMTAuMC44MS41OjM4OS9jbj1k"
    "cF9rXy1vQ0RQNFFPLWlxZl9EQUVkM2lncDAsb3U9UEtJLG89UEVOVEEsYz1LUjAKBggqhkjOPQQDAgM3ADA0AhgjNG0Ojm5DQNd+/mppOYIuqX+6"
    "LesJHtUCGFzr6NzVgCsc4dxJYI7/M5nXCkz9Yn2eDA==";
static unsigned char certBytes[4096] = { 0, };
static int certBytesLen = 0;
static const char *priKeyB64 =
    "MIGfMBoGCCqDGoyaRAEPMA4ECIdWIwZIMicUAgIFSQSBgCYPLXhPSN6vCQFt7TjDTmQivYIyl9q/Je2YbX2QTGRMCxEXPliYiQNdk4EjP6KV43Uh"
    "HLeu9zR4NCf59DQAisTn5eHB3m1j3U6Xo801e27aiSGPEh6bKCctfKYHjBhJrLUJt6126McBlTWTtoP2hxlGgY8o1ySin96fy5K+IMHJ";
static unsigned char priKeyBytes[2048] = { 0, };
static int priKeyBytesLen = 0;
static const char *password = "jkljkl..";


static int sample_setup() {
    ISSAC_RETURN result;

    result = ISSAC_Initialize();
    if (result != ISSAC_SUCCESS) {
        printf("[ERROR] %s\n", ISSAC_GetErrorMessage(result));
        return 1;
    }
    result = ISSAC_BASE64_Decode(certBytes, &certBytesLen, sizeof(certBytes), certB64);
    if (result != ISSAC_SUCCESS) {
        printf("[ERROR] %s\n", ISSAC_GetErrorMessage(result));
        return 1;
    }
    result = ISSAC_BASE64_Decode(priKeyBytes, &priKeyBytesLen, sizeof(priKeyBytes), priKeyB64);
    if (result != ISSAC_SUCCESS) {
        printf("[ERROR] %s\n", ISSAC_GetErrorMessage(result));
        return 1;
    }
    return 0;
}

static int sample_sg_pkcs7() {
    ISSAC_RETURN result;
    char pkcs7[4096];   // PKCS#7 ޽  
    int pkcs7_len;      // PKCS#7 ޽ 
    const char *message = "this is a test!";    //    ޽
    int message_len = strlen(message);          //  ޽ 

    printf("sample_sg_pkcs7() => ");

    // PKCS#7 
    {
        PRIVATEKEY key;
        CERTIFICATE certificate;
        char signeddata[4096];   // SignedData ޽  
        int signeddata_len;      // SignedData ޽ 
    
        // ü ʱȭ
        ISSAC_PRIVATEKEY_Create(&key);
        ISSAC_CERTIFICATE_Create(&certificate);

        //    Ű б
        result = ISSAC_CERTIFICATE_Read_Memory(&certificate, certBytes, certBytesLen);
        if (result == ISSAC_SUCCESS) {
            result = ISSAC_PRIVATEKEY_Read_Memory(&key, priKeyBytes, priKeyBytesLen, password);
        }
        // SignedData ϱ
        if (result == ISSAC_SUCCESS) {
            result = ISSAC_SG_MakeSignature_WithHashNid(signeddata, &signeddata_len, sizeof(signeddata), message, message_len, &key, &certificate, 10, 385);
        }
        // SignedData PKCS#7  
        if (result == ISSAC_SUCCESS) {
            result = ISSAC_AddContentInfoType(pkcs7, &pkcs7_len, sizeof(pkcs7), signeddata, signeddata_len, 69);
        }
        
        // ü ޸ ȯ
        ISSAC_PRIVATEKEY_Delete(&key);
        ISSAC_CERTIFICATE_Delete(&certificate);
    }

    // PKCS#7    
    if (result == ISSAC_SUCCESS) {
        char signeddata[4096];   // SignedData ޽  
        int signeddata_len;      // SignedData ޽ 

        // PKCS#7  SignedData 
        result = ISSAC_DeleteContentInfoType(signeddata, &signeddata_len, sizeof(signeddata), pkcs7, pkcs7_len, 69);
        // SignedData 
        if (result == ISSAC_SUCCESS) {
            result = ISSAC_SG_VerifySignature_WithHashNid(signeddata, signeddata_len, 385);
        }
        // SignedData   ޽ 
        if (result == ISSAC_SUCCESS) {
            char original_message[256]; // SignedData и  ޽  
            int original_message_len;   // SignedData и  ޽ 
            time_t sign_time;
            result = ISSAC_SG_GetOriginalMessage(&sign_time, original_message, &original_message_len, sizeof(original_message), signeddata, signeddata_len);
        }
        // SignedData  
        if (result == ISSAC_SUCCESS) {
            CERTIFICATE tmpcert;
            ISSAC_CERTIFICATE_Create(&tmpcert);
            result = ISSAC_SG_GetSignerCertificate(&tmpcert, signeddata, signeddata_len);
            ISSAC_CERTIFICATE_Delete(&tmpcert);
        }
    }

    if (result == ISSAC_SUCCESS) {
        printf("[OK]\n");
        return 0;
    } else {
        printf("[ERROR] %s\n", ISSAC_GetErrorMessage(result));
        return 1;
    }
}

int main() {
    int result;

    result = sample_setup();
    if (result != 0) {
        return result;
    }

    return sample_sg_pkcs7();
}
