#include <stdio.h>

#include "issacapi_bs.h"
#include "issacapi_sg.h"
#include "issacapi_errorcode.h"

/**
 * <pre>
 * ߱޴ : cn=ECDSA_secp192r1,ou=PKI,o=PENTA,c=KR
 * ߱ : cn=ECCCA,ou=PKI,o=PENTA,c=KR
 * ȿⰣ : 2017/07/20 ~ 2018/07/20
 * Ű : EC - secp192r1
 *  ˰ : ecdsa-with-SHA256
 * CRL  : ldap://10.0.81.5:389/cn=dp_k_-oCDP4QO-iqf_DAEd3igp0,ou=PKI,o=PENTA,c=KR
 * </pre>
 */
static const char *certB64 =
    "MIICZzCCAh6gAwIBAgIGAOjUpRACMAoGCCqGSM49BAMCMDsxCzAJBgNVBAYTAktSMQ4wDAYDVQQKDAVQRU5UQTEMMAoGA1UECwwDUEtJMQ4wDAYD"
    "VQQDDAVFQ0NDQTAeFw0xNzA3MTkxNTAwMDBaFw0xODA3MjAxNDU5NTlaMEUxCzAJBgNVBAYTAktSMQ4wDAYDVQQKDAVQRU5UQTEMMAoGA1UECwwD"
    "UEtJMRgwFgYDVQQDDA9FQ0RTQV9zZWNwMTkycjEwSTATBgcqhkjOPQIBBggqhkjOPQMBAQMyAAQwfngoTe35z/5fShA3saeGqfrcDi0NF9wr8b5b"
    "3DJGXhVObNFqLrh8IadKOR6kjR6jggESMIIBDjBkBgNVHSMEXTBbgBT0gEWgUNnasgeM2CjTJuYtHHkiFaFApD4wPDELMAkGA1UEBhMCS1IxDjAM"
    "BgNVBAoMBVBFTlRBMQwwCgYDVQQLDANQS0kxDzANBgNVBAMMBkVDQ1JDQYIBAjAdBgNVHQ4EFgQU++yqycDRrNEZTorCL1OUCGWyGZYwDgYDVR0P"
    "AQH/BAQDAgPoMB0GA1UdJQQWMBQGCCsGAQUFBwMBBggrBgEFBQcDAjBYBgNVHR8EUTBPME2gS6BJhkdsZGFwOi8vMTAuMC44MS41OjM4OS9jbj1k"
    "cF9rXy1vQ0RQNFFPLWlxZl9EQUVkM2lncDAsb3U9UEtJLG89UEVOVEEsYz1LUjAKBggqhkjOPQQDAgM3ADA0AhgjNG0Ojm5DQNd+/mppOYIuqX+6"
    "LesJHtUCGFzr6NzVgCsc4dxJYI7/M5nXCkz9Yn2eDA==";
static unsigned char certBytes[4096] = { 0, };
static int certBytesLen = 0;
static const char *priKeyB64 =
    "MIGfMBoGCCqDGoyaRAEPMA4ECIdWIwZIMicUAgIFSQSBgCYPLXhPSN6vCQFt7TjDTmQivYIyl9q/Je2YbX2QTGRMCxEXPliYiQNdk4EjP6KV43Uh"
    "HLeu9zR4NCf59DQAisTn5eHB3m1j3U6Xo801e27aiSGPEh6bKCctfKYHjBhJrLUJt6126McBlTWTtoP2hxlGgY8o1ySin96fy5K+IMHJ";
static unsigned char priKeyBytes[2048] = { 0, };
static int priKeyBytesLen = 0;
static const char *password = "jkljkl..";


static int sample_setup() {
    ISSAC_RETURN result;

    result = ISSAC_Initialize();
    if (result != ISSAC_SUCCESS) {
        printf("[ERROR] %s\n", ISSAC_GetErrorMessage(result));
        return 1;
    }
    result = ISSAC_BASE64_Decode(certBytes, &certBytesLen, sizeof(certBytes), certB64);
    if (result != ISSAC_SUCCESS) {
        printf("[ERROR] %s\n", ISSAC_GetErrorMessage(result));
        return 1;
    }
    result = ISSAC_BASE64_Decode(priKeyBytes, &priKeyBytesLen, sizeof(priKeyBytes), priKeyB64);
    if (result != ISSAC_SUCCESS) {
        printf("[ERROR] %s\n", ISSAC_GetErrorMessage(result));
        return 1;
    }
    return 0;
}

static int sample_sg_rawbytes() {
    ISSAC_RETURN result;
    CERTIFICATE cert;

    char signature[4096];   // ڼ ޽  
    int signature_len;      // ڼ ޽ 
    const char *message = "this is a test!";    //    ޽
    int message_len = strlen(message);          //  ޽ 

    printf("sample_sg_rawbytes() => ");

    //  б
    ISSAC_CERTIFICATE_Create(&cert);
    result = ISSAC_CERTIFICATE_Read_Memory(&cert, certBytes, certBytesLen);

    //  
    if (result == ISSAC_SUCCESS) {
        PUBLICKEY pubKey;
        PRIVATEKEY priKey;

        ISSAC_PUBLICKEY_Create(&pubKey);
        ISSAC_PRIVATEKEY_Create(&priKey);

        //  Ű 
        result = ISSAC_PUBLICKEY_ReadFromCertificate(&pubKey, &cert);
        // Ű б
        if (result == ISSAC_SUCCESS) {
            result = ISSAC_PRIVATEKEY_Read_Memory(&priKey, priKeyBytes, priKeyBytesLen, password);
        }
        //  
        if (result == ISSAC_SUCCESS) {
            result = ISSAC_SignRawBytes_WithHashNid(signature, &signature_len, sizeof(signature), message, message_len, &priKey, &pubKey, 385);
        }

        ISSAC_PUBLICKEY_Finalize(&pubKey);
        ISSAC_PRIVATEKEY_Delete(&priKey);
    }

    //  
    if (result == ISSAC_SUCCESS) {
        result = ISSAC_SG_VerifySignature_Core_WithHashNid(signature, signature_len, message, message_len, &cert, 0, 385);
    }

    ISSAC_CERTIFICATE_Delete(&cert);

    if (result == ISSAC_SUCCESS) {
        printf("[OK]\n");
        return 0;
    } else {
        printf("[ERROR] %s\n", ISSAC_GetErrorMessage(result));
        return 1;
    }
}

int main() {
    int result;

    result = sample_setup();
    if (result != 0) {
        return result;
    }

    return sample_sg_rawbytes();
}
