#include <stdio.h>

#include "issacapi_bs.h"
#include "issacapi_usr.h"
#include "issacapi_errorcode.h"

 /* <pre>
  * ߱޴ : cn=׽Ʈ(-A),ou=RA,ou=TEST,ou=TEST߱޿,ou=licensedCA,o=KICA,c=KR
  * ߱ : cn=signGATE CA5,ou=AccreditedCA,o=KICA,c=KR
  * ȿⰣ : 2019/07/18 ~ 2020/07/19
  * Ű : RSA 2048
  *  ˰ : sha256WithRSAEncryption
  * </pre>
  */
static const char *certB64 =
    "MIIFcDCCBFigAwIBAgIEBOOmQDANBgkqhkiG9w0BAQsFADBKMQswCQYDVQQGEwJLUjENMAsGA1UECgwES0lDQTEVMBMGA1UECwwMQWNjcmVkaXRl"
    "ZENBMRUwEwYDVQQDDAxzaWduR0FURSBDQTUwHhcNMTkwNzE4MDEzODI4WhcNMjAwNzE5MTQ1OTU5WjCBkjELMAkGA1UEBhMCS1IxDTALBgNVBAoM"
    "BEtJQ0ExEzARBgNVBAsMCmxpY2Vuc2VkQ0ExFjAUBgNVBAsMDVRFU1TrsJzquInsmqkxFjAUBgNVBAsMDVRFU1Tsnbjspp3shJwxETAPBgNVBAsM"
    "CFJB7IS87YSwMRwwGgYDVQQDDBPthYzsiqTtirgo67KV7J24LUEpMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAs/0ZlxnYgA1RgfCR"
    "jUA+5A+2//k74rzNE2KTVD//ulxYViRnBGnPEBOegaP0ZEfhUm4T50utynUnmv6VTy4YC/yvLzbu+x4S1bsStluIUN6VJSfVW3jYHTvTadZeXHW7"
    "oQg6BtmMbRWX16PIwqxZ29fcO8NrQ+XFUAvVF22K3GLYdEga4l6W5iT2Jg0YUJZi1gozYAkd2bNeShyTOi+/mDQbPUr3zUfjYtmU+rEsjWWTUx9x"
    "+VLMC0oRsVIrAWHoj8Iyew07+OCgvQPoSgiEaFCcC4Pph75jNdlGERvTBDjraSerIqqp3d6gctXi5HtrDeT3ldm8sLshoNrQDL6yIwIDAQABo4IC"
    "EzCCAg8wgY8GA1UdIwSBhzCBhIAU2L467EWZxZ7jnOqBH9IdErA2PoihaKRmMGQxCzAJBgNVBAYTAktSMQ0wCwYDVQQKDARLSVNBMS4wLAYDVQQL"
    "DCVLb3JlYSBDZXJ0aWZpY2F0aW9uIEF1dGhvcml0eSBDZW50cmFsMRYwFAYDVQQDDA1LSVNBIFJvb3RDQSA0ggIQHTAdBgNVHQ4EFgQUnrcKqP2A"
    "ud+LdDCYTf3wDiCq4xAwDgYDVR0PAQH/BAQDAgUgMBcGA1UdIAQQMA4wDAYKKoMajJpEBQIBATCBiwYDVR0RBIGDMIGAgRVwdXJlMjcxM0BzaWdu"
    "Z2F0ZS5jb22gZwYJKoMajJpECgEBoFowWAwT7YWM7Iqk7Yq4KOuyleyduC1BKTBBMD8GCiqDGoyaRAoBAQEwMTALBglghkgBZQMEAgGgIgQgKitY"
    "vdm0gRTpVhMYPG+TQKIkVjffUR9NMEks9r0Q5IkwXwYDVR0fBFgwVjBUoFKgUIZObGRhcDovL2xkYXAuc2lnbmdhdGUuY29tOjM4OS9vdT1kcDdw"
    "MTUwMjksb3U9Y3JsZHAsb3U9QWNjcmVkaXRlZENBLG89S0lDQSxjPUtSMEQGCCsGAQUFBwEBBDgwNjA0BggrBgEFBQcwAYYoaHR0cDovL29jc3Au"
    "c2lnbmdhdGUuY29tOjkwMjAvT0NTUFNlcnZlcjANBgkqhkiG9w0BAQsFAAOCAQEAf9c0cN/64IYMApJkackYGuK+FZ0YzIHfksokUlEnuFerPVul"
    "X7jKyEhS9tU6Q4E+vsJwAQQtqI7IUHHqym6OPrY8gLvtzwmRVJRvdLMyRvhrdoseb3xaTA/gqYch/TtNk7qwYlO4b10DLUCVTK9wubbLscOZ3uFO"
    "XsrU6t1Lms9VnfVuZPFa+TH9LJ7pdLjbEGtSV+HZ+uNbdxfbTsgmDGux98E+MJqR7AsqnOICE/9W+lWPk3nNEKwWW7KA5SaRw38wgrJQDqoi7GlW"
    "pTbrYVv2M/IoSGMHipAEoPBzqU8nrnjiHVWatycNNGZGKQ8Jy7gAvbItl1xjjqIAsMQm3Q==";
static unsigned char certBytes[4096] = { 0, };
static int certBytesLen = 0;


static int sample_setup() {
    ISSAC_RETURN result;

    result = ISSAC_Initialize();
    if (result != ISSAC_SUCCESS) {
        printf("[ERROR] %s\n", ISSAC_GetErrorMessage(result));
        return 1;
    }
    result = ISSAC_BASE64_Decode(certBytes, &certBytesLen, sizeof(certBytes), certB64);
    if (result != ISSAC_SUCCESS) {
        printf("[ERROR] %s\n", ISSAC_GetErrorMessage(result));
        return 1;
    }
    result = ISSAC_USR_SetCacheDir(".");
    if (result != ISSAC_SUCCESS) {
        printf("[ERROR] %s\n", ISSAC_GetErrorMessage(result));
        return 1;
    }
    return 0;
}

static int sample_usr_path_validation_ex() {
    ISSAC_RETURN result;
    CERTIFICATE cert;
    CERTIFICATES caCerts;
    CERTIFICATES trustedCaCerts;
    CERTIFICATEREVLIST crl;
    DLCONTEXT ldapInfo;
    PATHS path;

    printf("sample_usr_path_validation_ex() => ");

    ISSAC_CERTIFICATE_Create(&cert);
    ISSAC_CERTIFICATES_Create(&caCerts);
    ISSAC_CERTIFICATES_Create(&trustedCaCerts);
    ISSAC_CERTIFICATEREVLIST_Create(&crl);
    ISSAC_DLCONTEXT_Create(&ldapInfo);
    ISSAC_PATHS_Create(&path);

    result = ISSAC_CERTIFICATE_Read_Memory(&cert, certBytes, certBytesLen);
    if (result == ISSAC_SUCCESS) {
        // NPKI only
        result = ISSAC_USR_MakeCertPath(&caCerts, &trustedCaCerts, &crl, &ldapInfo, &cert);
    }
    if (result == ISSAC_SUCCESS) {
        result = ISSAC_CERTIFICATE_VerifyEx(&path, &cert, &caCerts, &trustedCaCerts, NULL, &crl, 0, VERIFY_IGNOREPOLICYCHECKING);
    }

    ISSAC_CERTIFICATE_Delete(&cert);
    ISSAC_CERTIFICATES_Delete(&caCerts);
    ISSAC_CERTIFICATES_Delete(&trustedCaCerts);
    ISSAC_CERTIFICATEREVLIST_Delete(&crl);
    ISSAC_DLCONTEXT_Delete(&ldapInfo);
    ISSAC_PATHS_Delete(&path);

    //if (result == ISSAC_SUCCESS) {
    // ׽Ʈ   츦 Ͽ ᵵ  Ѵ. (Ǽ ݿ   óؾ )
    if (result == ISSAC_SUCCESS || result == ER_VERIFY_EXPIRED) {
        printf("[OK]\n");
        return 0;
    } else {
        printf("[ERROR] %s\n", ISSAC_GetErrorMessage(result));
        return 1;
    }
}

int main() {
    int result;

    result = sample_setup();
    if (result != 0) {
        return result;
    }

    return sample_usr_path_validation_ex();
}
