#include <stdio.h>

#include "issacapi_bs.h"
#include "issacapi_va.h"
#include "issacapi_errorcode.h"

/**
 * <pre>
 * ߱޴ : cn=192.168.21.225,dc=,ou=TEST,o=TEST,c=KR
 * ߱ : cn=TESTCA,ou=TEST,o=TEST,c=KR
 * ȿⰣ : 2018/11/12 ~ 2019/02/20
 * Ű : EC - secp192r1
 *  ˰ : sha256WithRSAEncryption
 * AIA : http://10.0.81.6:8080/OCSPServer
 * </pre>
 */
static const char *certB64 =
    "MIIDOjCCAiSgAwIBAgIGAOjUpRAhMAsGCSqGSIb3DQEBCzA8MQswCQYDVQQGEwJLUjENMAsGA1UECgwEVEVTVDENMAsGA1UECwwEVEVTVDEPMA0G"
    "A1UEAwwGVEVTVENBMB4XDTE4MTExMTE1MDAwMFoXDTE5MDIyMDE0NTk1OVowVjELMAkGA1UEBhMCS1IxDTALBgNVBAoMBFRFU1QxDTALBgNVBAsM"
    "BFRFU1QxEDAOBgoJkiaJk/IsZAEZFgAxFzAVBgNVBAMMDjE5Mi4xNjguMjEuMjI1MEkwEwYHKoZIzj0CAQYIKoZIzj0DAQEDMgAEMv2XdC0mcCen"
    "uMRmsOyDOD1Kn+7Jt/8z25bVeLk8+WaflsEfrgNoXA28C5i2XBdNo4IBBTCCAQEwYgYDVR0jBFswWYAUzDoinqM+0/wZ18YirsUGPeDJWPihPqQ8"
    "MDoxCzAJBgNVBAYTAktSMQ0wCwYDVQQKDARURVNUMQ0wCwYDVQQLDARURVNUMQ0wCwYDVQQDDARURVNUggECMB0GA1UdDgQWBBQm1cQqp6uN/6l9"
    "uEmWGBZ3xHM72DAOBgNVHQ8BAf8EBAMCB4AwHQYDVR0lBBYwFAYIKwYBBQUHAwEGCCsGAQUFBwMCMA8GA1UdEQQIMAaHBMCoFeEwPAYIKwYBBQUH"
    "AQEEMDAuMCwGCCsGAQUFBzABhiBodHRwOi8vMTAuMC44MS42OjgwODAvT0NTUFNlcnZlcjALBgkqhkiG9w0BAQsDggEBADgaJ/ZQ5LABTw+HiPbb"
    "V9ZrwgPMpkfoHF1j2vivNJZ/jnVaghQEOrsrIHcN9jKr1UVisSZjMc1SnCSa7VqNZcmsnXYbBkXY8iFa9O3PO+ZiYerEGxf6VbFhGFTbGT9LA2iz"
    "eX/PGENL/jrRUFMmZBpaZk0/1xMJg1rx+fyvToFVzXHL0H00dxv/Stb96qBlYixUdCTfscSU3w6SMzqv2NWRRkgG37ZvL0HT+tPAZ7AZzUbMR7g6"
    "5+PXsnJzavPLitdSBcDV/Oa14bfW4zlHH0EaMCr79QJm6n4YPM2P5SUT4pJlTg/jbJwNHcOoYa3bHuq4sbAo5PFBlFq+np0OorQ=";
static unsigned char certBytes[4096] = { 0, };
static int certBytesLen = 0;

/**
 * <pre>
 * ߱޴ : cn=TESTCA,ou=TEST,o=TEST,c=KR
 * ߱ : cn=TEST,ou=TEST,o=TEST,c=KR
 * ȿⰣ : 2018/10/10 ~ 2029/10/10
 * Ű : RSA 2048
 *  ˰ : sha256WithRSAEncryption
 * CRL  : http://10.0.81.5:8080/cn=TEST,ou=TEST,o=TEST,c=KR.crl
 * </pre>
 */
static const char *issuerCertB64 =
    "MIID5DCCAsygAwIBAgIBAjANBgkqhkiG9w0BAQsFADA6MQswCQYDVQQGEwJLUjENMAsGA1UECgwEVEVTVDENMAsGA1UECwwEVEVTVDENMAsGA1UE"
    "AwwEVEVTVDAeFw0xODEwMTAwNzI0MzRaFw0yOTEwMTAwNzI0MzRaMDwxCzAJBgNVBAYTAktSMQ0wCwYDVQQKDARURVNUMQ0wCwYDVQQLDARURVNU"
    "MQ8wDQYDVQQDDAZURVNUQ0EwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQCQuar4BDageAAUPqgDhUiQMFGATvRz6SY8Rao8jnyr7ZgG"
    "Y9ooO+BWCNPNw4h8+ajx59w0LtvYCiIfq7owVT08nvDCxygAdLW8F53gifvRMntkvzxTQnOxURYrT/rBBwrJ/x4zv+t3c7ObtsQOXNlG2CkuG5R/"
    "//D9db5wZADJQ3a7J0NBDD5njXytErsLu/HjZXBqWhFs1+H+R2iQufZWhnsrGpg8JcgK5/Jg7ZBLV9gHQTLMXViey4zgk2IyTSprH+xtKoNzK1BQ"
    "9xmXLHc0bVmT0sOAzsximlLM/HUx6ZTj7pgYWDQgv+QKrG1dcyRlylrdYRJ4zbT14LOYY84jAgMBAAGjgfIwge8wHQYDVR0OBBYEFMw6Ip6jPtP8"
    "GdfGIq7FBj3gyVj4MGIGA1UdIwRbMFmAFKpLnpsr0JWpkKf6e1RlokozwyPdoT6kPDA6MQswCQYDVQQGEwJLUjENMAsGA1UECgwEVEVTVDENMAsG"
    "A1UECwwEVEVTVDENMAsGA1UEAwwEVEVTVIIBATAOBgNVHQ8BAf8EBAMCAQYwEgYDVR0TAQH/BAgwBgEB/wIBADBGBgNVHR8EPzA9MDugOaA3hjVo"
    "dHRwOi8vMTAuMC44MS41OjgwODAvY249VEVTVCxvdT1URVNULG89VEVTVCxjPUtSLmNybDANBgkqhkiG9w0BAQsFAAOCAQEAbS8GYh0QcWtJxolZ"
    "825b3yckgpMg/slPwNUnfXRv5eAMlMowf1uzhU/5761NhsTDzU4fc4ZszUsgDdwls7VOGgUO0SAlwGaVntrrkLtsBJAVoWiYYw1L5evsVTVf1jhb"
    "h83++f8NcEgLmifO1e2XZN0NunsHchn5dnYgZI0qQOvXn0T0bJC7htYuNcaGvwR5Lyg2IOEu2reZ7w2rA7fQgLGXJJZRENxR4LspqvnBdJ8Dzjmi"
    "1klPjZVMb18eZhgZOhB+G7sZfwgqEIA2OTAaA2sjgUo5rR78svn5zJxHtFE3W1tx/EkSkFdUjpX4k2aM9C11uZyu+CfQdDuxu9yoBg==";
static unsigned char issuerCertBytes[4096] = { 0, };
static int issuerCertBytesLen = 0;


static int sample_setup() {
    ISSAC_RETURN result;

    result = ISSAC_Initialize();
    if (result != ISSAC_SUCCESS) {
        printf("[ERROR] %s\n", ISSAC_GetErrorMessage(result));
        return 1;
    }
    result = ISSAC_BASE64_Decode(certBytes, &certBytesLen, sizeof(certBytes), certB64);
    if (result != ISSAC_SUCCESS) {
        printf("[ERROR] %s\n", ISSAC_GetErrorMessage(result));
        return 1;
    }
    result = ISSAC_BASE64_Decode(issuerCertBytes, &issuerCertBytesLen, sizeof(issuerCertBytes), issuerCertB64);
    if (result != ISSAC_SUCCESS) {
        printf("[ERROR] %s\n", ISSAC_GetErrorMessage(result));
        return 1;
    }
    return 0;
}

int sample_va_basic() {
    ISSAC_RETURN result;
    CERTIFICATE targetCert;         // ϰ ϴ 
    CERTIFICATES targetCerts;       // ϰ ϴ  
    CERTIFICATE targetIssuerCert;   // ϰ ϴ  ߱ 
    CERTIFICATES targetIssuerCerts; // ϰ ϴ  ߱  
    VACONTEXT info;                 // OCSP   

    printf("sample_va_basic() => ");

    // ü 
    ISSAC_CERTIFICATE_Create(&targetCert);
    ISSAC_CERTIFICATES_Create(&targetCerts);
    ISSAC_CERTIFICATE_Create(&targetIssuerCert);
    ISSAC_CERTIFICATES_Create(&targetIssuerCerts);
    ISSAC_VA_VACONTEXT_Create(&info);

    //  
    result = ISSAC_CERTIFICATE_Read_Memory(&targetCert, certBytes, certBytesLen);
    if (result == ISSAC_SUCCESS) {
        result = ISSAC_CERTIFICATES_AddCertificate(&targetCerts, &targetCert);
    }

    //   ߱
    if (result == ISSAC_SUCCESS) {
        result = ISSAC_CERTIFICATE_Read_Memory(&targetIssuerCert,issuerCertBytes, issuerCertBytesLen);
    }
    if (result == ISSAC_SUCCESS) {
        result = ISSAC_CERTIFICATES_AddCertificate(&targetIssuerCerts, &targetIssuerCert);
    }

    if (result == ISSAC_SUCCESS) {
        // OCSP   ( AIA  ִ )
        //result = ISSAC_VA_VACONTEXT_Set(&info, NULL, NULL, 0, NULL, &targetCert);
        // OCSP   ( AIA    - http://10.0.81.6:8080/OCSPServer)
        result = ISSAC_VA_VACONTEXT_Set(&info, "http", "10.0.81.6", 8080, "/OCSPServer", &targetCert);
    }

    if (result == ISSAC_SUCCESS) {
        while (1) {
            OCSPREQUEST ocspRequest;
            OCSPRESPONSE ocspResponse;
            ISSAC_VA_OCSPREQUEST_Create(&ocspRequest);
            ISSAC_VA_OCSPRESPONSE_Create(&ocspResponse);

            //  û ޽ 
            //result = ISSAC_VA_OCSPREQUEST_Make(&ocspRequest, &targetCerts, &targetIssuerCerts);
            result = ISSAC_VA_OCSPREQUEST_Make_WithHashNid(&ocspRequest, &targetCerts, &targetIssuerCerts, 385);

            //   û ޽ OCSP  ۽
            if (result == ISSAC_SUCCESS) {
                result = ISSAC_VA_OCSPREQUEST_SendToServer(&ocspRequest, &info);
            }

            // κ     
            if (result == ISSAC_SUCCESS) {
                int nStatus; // ISSAC-API ڵ() Ǵ  ִ Response 
                nStatus = ISSAC_VA_OCSPRESPONSE_ReceiveFromServer(&ocspResponse, &info);
                if (nStatus == RESPONSE_TRY_LATER) {
                    // õ û
                    ISSAC_VA_OCSPREQUEST_Delete(&ocspRequest);
                    ISSAC_VA_OCSPRESPONSE_Delete(&ocspResponse);
                    continue;
                }
                if (nStatus == RESPONSE_SUCCESS) {
                    // OCSP Request  ´ OCSP Response  Ȯ
                    if (result == ISSAC_SUCCESS) {
                        result = ISSAC_VA_OCSPRESPONSE_CheckValid(&ocspResponse, &ocspRequest, 0);
                    }
                    //  û   (ʿ )
                    if (result == ISSAC_SUCCESS) {
                        CERTIFICATE ownCertFromResponse;
                        result = ISSAC_CERTIFICATE_Create(&ownCertFromResponse);
                        if (result == ISSAC_SUCCESS) {
                            result = ISSAC_VA_OCSPRESPONSE_GetResponderCert(&ownCertFromResponse, &ocspResponse);
                            ISSAC_CERTIFICATE_Delete(&ownCertFromResponse);
                        }
                    }
                    //   Ȯ
                    if (result == ISSAC_SUCCESS) {
                        //    
                        CERTSTATUS certStatus;
                        result = ISSAC_VA_OCSPRESPONSE_GetCertStatus(&ocspResponse, &certStatus);
                        if (result == ISSAC_SUCCESS) {
                            CERTIFICATESTATUS singleStatus; //   1: good 2: revoked 3: unknown
                            result = ISSAC_VA_CERTSTATUS_GetSingleStatus(&singleStatus, 0, &certStatus);
                        }
                        ISSAC_VA_CERTSTATUS_Delete(&certStatus);
                    }
                } else {
                    result = nStatus;
                }
            }
            ISSAC_VA_OCSPREQUEST_Delete(&ocspRequest);
            ISSAC_VA_OCSPRESPONSE_Delete(&ocspResponse);
            break;
        }
    }

    // ü 
    ISSAC_CERTIFICATE_Delete(&targetCert);
    ISSAC_CERTIFICATES_Delete(&targetCerts);
    ISSAC_CERTIFICATE_Delete(&targetIssuerCert);
    ISSAC_CERTIFICATES_Delete(&targetIssuerCerts);
    ISSAC_VA_VACONTEXT_Delete(&info);

    if (result == ISSAC_SUCCESS) {
        printf("[OK]\n");
        return 0;
    } else {
        printf("[ERROR] %s\n", ISSAC_GetErrorMessage(result));
        return 1;
    }
}

int main() {
    int result;

    result = sample_setup();
    if (result != 0) {
        return result;
    }

    return sample_va_basic();
}
