#include <stdio.h>

#include "issacweb.h"


static int sample_setup() {
    EErrorCode result = wasdk_init();
    if (result != EEC_Success) {
        printf("[ERROR] %s\n", wasdk_error_message(result));
        return 1;
    }
    return 0;
}

static int sample_issacweb_base64() {
    const char *orgMsg = "TEST Message";
    int orgMsgLen = (int) strlen(orgMsg);
    char encoded[64] = { 0, };
    unsigned char decoded[64] = { 0, };
    int encodedLen = 0;
    int decodedLen = 0;

    printf("sample_issacweb_base64() => ");

    encodedLen = issacweb_base64_encode((issac_string) encoded, (issac_binary) orgMsg, orgMsgLen);
    if (encodedLen <= 0) {
        printf("[ERROR] %s\n", errorcode_to_string(encodedLen));
        return 1;
    }

    decodedLen = issacweb_base64_decode((issac_binary) decoded, (issac_string) encoded);
    if (encodedLen <= 0) {
        printf("[ERROR] %s\n", errorcode_to_string(decodedLen));
        return 1;
    }

    printf("[OK]\n");

    return 0;
}

int main() {
    int result;

    result = sample_setup();
    if (result != 0) {
        return result;
    }

    return sample_issacweb_base64();
}
