#include <stdio.h>

#include "issacweb.h"

static const char *pubKeyB64 =
    "MIIBCgKCAQEApxmx2JocFsL9VKaHi4IGS518XL/pCk84t1hs/C8vH7zAbTYuzPTCebQ1vxJVVd6Bpe8vWwUSgQcMNAU16lZvYj+XS+/WFuND41GJ"
    "rO4qeuSGEXNPIIhgXVI0I1sSv4H/neAMWARzUWxmQNdeLFNu4I3x+z0OkfHyRJ8dS9GmaZ7dg7Rc3ART/LdYkZCCbBAEWaMLzOgCh4U/OkK1m/HQ"
    "ocaxuI0VYRUpbcqroncHTczbqZ6+JptV2QUsFvMRL2ORbugbx3MYjISCYf6yImn+TDxuu5hqUHagDEKyEMZWdi6z0fKi7Fhah5lN0WmnGCpQGJ6L"
    "sjQSWjZEZl3eWdoqaQIDAQAB";
static const char *priKeyB64 =
    "MIIEowIBAAKCAQEApxmx2JocFsL9VKaHi4IGS518XL/pCk84t1hs/C8vH7zAbTYuzPTCebQ1vxJVVd6Bpe8vWwUSgQcMNAU16lZvYj+XS+/WFuND"
    "41GJrO4qeuSGEXNPIIhgXVI0I1sSv4H/neAMWARzUWxmQNdeLFNu4I3x+z0OkfHyRJ8dS9GmaZ7dg7Rc3ART/LdYkZCCbBAEWaMLzOgCh4U/OkK1"
    "m/HQocaxuI0VYRUpbcqroncHTczbqZ6+JptV2QUsFvMRL2ORbugbx3MYjISCYf6yImn+TDxuu5hqUHagDEKyEMZWdi6z0fKi7Fhah5lN0WmnGCpQ"
    "GJ6LsjQSWjZEZl3eWdoqaQIDAQABAoIBAAIXpKYUTu37iNHIqImXChZkDVC5f/Tmt0x3bVzuh9HnSocLjsQ2++DrgGFJPNuPhtLRtwd2HaxTLuRP"
    "XOSXarthlbbIFOeSNrFH3fgV/t7tUd7x0U+0WXWNsBSxwR84BOAAlFL9UkbWm0SsVbPrIwgpitpFIlOyQoD4t5SRllp78za9YgkDHQMBxHtnTrUZ"
    "t2JtO/1deLOlWhyex8UU0QhS7fC8vrCRmkQCzY85oPn29mLWghNHXUCDysl3K0uV+SH7u1s3c5wLRGiQNUKZF+HJXsEWd9hfrSqtPAvCv6cB6Rzd"
    "K5HWlucyAsV5uynz/pOL+V2kiodMczRy74WJqFECgYEAy9jauShEMk5XHZ8lrrtXAukc6bl2P+QOhFcrPrvj9jK80qYfijtWDe7sLOswsSClQFxi"
    "xZaafeysGcTqiDNhZb32LwHNS/QRtuS7UWn4GGPuwwslC+P039BxusqONUh3Y1Pj7zKRjVyPqdsXTiZTemAbQ4+t07/rmOnP3kPkafECgYEA0doU"
    "3VR6rLLZ5aa3YLlJSmSX8NVqfIdK+cFRIfzsFl0c5XQ/KaQTdyz1etjAXbZRap7iE4kKxwmKiiYPoPbu9MLixFnFNISFhvNXeeS/5MZql4rKWQ2M"
    "TkxNhf8KQo5dPPzHoq6xAZDrKDKHVjJTc97KM4xYkT5PWR9QR+waD/kCgYB7hUwEJoIseYwQRv9ugdaXzOnYNqmQzYB+cNOjj/bymIwSmNdDy/C5"
    "QK2cCmfW7RE1jsXLNRcoduFSPCBhp8C9Bf7HPTBJdfvF95QKIUxUezmSto4cRmV7ubMwnMzPPLobVhooN1w7bHshUcEtecvbu6DJr6aFSSZZ4lQz"
    "OrCOAQKBgBEE0bpddpF488j3K1oRzMrWu6fRdxBgXIlCz1SlUXRC2uwU8GZtIxMAN2xeFcPD3Hh8KDOTYqdfs7eefJf+TsTU5VUtPpwSv02BgK+n"
    "CJUCLnTZ0a1FNwLGl2btlyRsrU0b5wjfiAVrflbFOkqYTEJSaC2kDS7CUecVbgpXMInpAoGBAKXjGh1hckKY64CV99P4Pf30wF9OCeQTaLpspPCJ"
    "wTnH+CuZ1TJ9j+fEvOlhpbmY2s1SKo/oi6JNpnEjXE+NR7BWBRvex2B5BT9Z5uBLcduEQp9W9+9q/onhvhoC6BtNopZyhHB4NDL5yAP93imLXEd0"
    "uey3rxjfOAzMopxvfH8k";


static int sample_setup() {
    EErrorCode result = wasdk_init();
    if (result != EEC_Success) {
        printf("[ERROR] %s\n", wasdk_error_message(result));
        return 1;
    }
    return 0;
}

static int sample_issacweb_hybrid_encryption() {
    const unsigned char plaintext[] = {
        0x80, 0x70, 0x60, 0x50, 0x40, 0x30, 0x20, 0x10,
        0x00, 0xF0, 0xE0, 0xD0, 0xC0, 0xB0, 0xA0, 0x90
    };
    unsigned char encrypted[512] = { 0, };
    unsigned char decrypted[512] = { 0, };
    int encryptedLen = 0;
    int decryptedLen = 0;
    char key[32] = { 0, };

    printf("sample_issacweb_hybrid_encryption() => ");

    encryptedLen = issacweb_hybrid_encrypt_ex2(encrypted, (unsigned char *) plaintext, sizeof(plaintext), pubKeyB64, key, ISSACWEB_SEED, ISSACWEB_SHA256);
    if (encryptedLen <= 0) {
        printf("[ERROR] %s\n", errorcode_to_string(encryptedLen));
        return 1;
    }

    decryptedLen = issacweb_hybrid_decrypt_ex2(decrypted, encrypted, encryptedLen, key, priKeyB64, ISSACWEB_SEED, ISSACWEB_SHA256);
    if (decryptedLen <= 0) {
        printf("[ERROR] %s\n", errorcode_to_string(decryptedLen));
        return 1;
    }

    printf("[OK]\n");

    return 0;
}

int main() {
    int result;

    result = sample_setup();
    if (result != 0) {
        return result;
    }

    return sample_issacweb_hybrid_encryption();
}
