#include <stdio.h>

#include "issacweb.h"


static int sample_setup() {
    EErrorCode result = wasdk_init();
    if (result != EEC_Success) {
        printf("[ERROR] %s\n", wasdk_error_message(result));
        return 1;
    }
    return 0;
}

static int sample_issacweb_symmetric_encryption_string() {
    const unsigned char plaintext[] = {
        0x80, 0x70, 0x60, 0x50, 0x40, 0x30, 0x20, 0x10,
        0x00, 0xF0, 0xE0, 0xD0, 0xC0, 0xB0, 0xA0, 0x90
    };
    unsigned char secretKey[] = {
        0x7B, 0xAA, 0x7D, 0x69, 0xAC, 0xE6, 0x52, 0xA0,
        0xD2, 0x1C, 0x16, 0x92, 0xAD, 0x91, 0x04, 0x1E
    };
    char encryptedB64[256] = { 0, };
    int encryptedLen = 0;
    char decrypted[256] = { 0, };
    int decryptedLen = 0;

    printf("sample_issacweb_symmetric_encryption_string() => ");

    encryptedLen = issacweb_encrypt_ex_s(encryptedB64, (unsigned char *) plaintext, sizeof(plaintext), secretKey, ISSACWEB_SEED);
    if (encryptedLen <= 0) {
        printf("[ERROR] %s\n", errorcode_to_string(encryptedLen));
        return 1;
    }

    decryptedLen = issacweb_decrypt_ex_s(decrypted, encryptedB64, secretKey, ISSACWEB_SEED);
    if (decryptedLen <= 0) {
        printf("[ERROR] %s\n", errorcode_to_string(decryptedLen));
        return 1;
    }

    printf("[OK]\n");

    return 0;
}

int main() {
    int result;

    result = sample_setup();
    if (result != 0) {
        return result;
    }

    return sample_issacweb_symmetric_encryption_string();
}
