#include <stdio.h>

#include "issacweb.h"


static int sample_setup() {
    EErrorCode result = wasdk_init();
    if (result != EEC_Success) {
        printf("[ERROR] %s\n", wasdk_error_message(result));
        return 1;
    }
    return 0;
}

static int sample_issacweb_timestamp() {
    int result;
    char timestamp[45] = { 0, };

    printf("sample_issacweb_timestamp() => ");

    result = issacweb_timestamp_get(timestamp);
    if (result != WASDK_SUCCESS) {
        printf("[ERROR] %s\n", errorcode_to_string(result));
        return 1;
    }

    result = issacweb_timestamp_verify(timestamp, 2);
    if (result != WASDK_SUCCESS) {
        printf("[ERROR] %s\n", errorcode_to_string(result));
        return 1;
    }

    printf("[OK]\n");

    return 0;
}

int main() {
    int result;

    result = sample_setup();
    if (result != 0) {
        return result;
    }

    return sample_issacweb_timestamp();
}
