#include <stdio.h>

#include "wasdk_public.h"

static int sample_setup() {
    EErrorCode result = wasdk_init();
    if (result != EEC_Success) {
        printf("[ERROR] %s\n", wasdk_error_message(result));
        return 1;
    }
    return 0;
}

static int sample_wasdk_base64() {
    EErrorCode result;
    // original is not string (not null terminated)
    const unsigned char original[] = { 'T','e','s','t' };
    char encoded[9] = { 0, };
    unsigned char decoded[4] = { 0, };
    int decodeSize = 0;

    printf("sample_wasdk_base64() => ");

    result = wasdk_base64_encoding(encoded, sizeof(encoded), original, sizeof(original));
    if (result != EEC_Success) {
        printf("[ERROR] %s\n", wasdk_error_message(result));
        return 1;
    }
    
    result = wasdk_base64_decoding(decoded, &decodeSize, sizeof(decoded), encoded);
    if (result != EEC_Success) {
        printf("[ERROR] %s\n", wasdk_error_message(result));
        return 1;
    }

    printf("[OK]\n");

    return 0;
}

int main() {
    int result;

    result = sample_setup();
    if (result != 0) {
        return result;
    }

    return sample_wasdk_base64();
}
