#include <stdio.h>

#include "wasdk_public.h"

static const char *testPubKey =
    "MIIBCgKCAQEAuM7qHl9N2cFFkGrpq7weCoK2TiSKSNSv8mWHjiLsbWvDToRHTk4iQ0DWp/H6E1z9/VZJQsvmrvIpw0vxmwnm+qTqgUfDRJ"
    "3UT9wkvbmuOKEYdh1YCI2Lwp/jcUPjg8RDV2nUWr6syTonEROGCEtD/nr91IpHQGQE3rae+Uny9FODBUR+dyvljlaKJsI381kz1Io3EVs1"
    "uHWx/iC/kLTHkIJ+L8kfaNA1uaWX3/wVpmu3vO82ETJ4Pp7XBAPFEncQyzHwU/J3K3I3kNbRX5uSI6jpZG20pzGeAZ4NM5zemrJI0JLq3U"
    "B2ZPL/bps7BQhaNOVsKTHbIeQsifQcBeX9LQIDAQAB";
static unsigned char pubKey[2048] = { 0, };
static int pubKeySize = 0;
static const char *testPriKey =
    "MIIEogIBAAKCAQEAuM7qHl9N2cFFkGrpq7weCoK2TiSKSNSv8mWHjiLsbWvDToRHTk4iQ0DWp/H6E1z9/VZJQsvmrvIpw0vxmwnm+qTqgU"
    "fDRJ3UT9wkvbmuOKEYdh1YCI2Lwp/jcUPjg8RDV2nUWr6syTonEROGCEtD/nr91IpHQGQE3rae+Uny9FODBUR+dyvljlaKJsI381kz1Io3"
    "EVs1uHWx/iC/kLTHkIJ+L8kfaNA1uaWX3/wVpmu3vO82ETJ4Pp7XBAPFEncQyzHwU/J3K3I3kNbRX5uSI6jpZG20pzGeAZ4NM5zemrJI0J"
    "Lq3UB2ZPL/bps7BQhaNOVsKTHbIeQsifQcBeX9LQIDAQABAoIBAAmfpsPloRtzi9CRLLFndqYD+APaNcREpRPpkxVE/sxU5gL+8uqiOXkI"
    "lZUBzgy3lTddyKtcjFr0W9XibMauzZMkRtzsFIBMeruc4mHp2ydyRiCSdxzc6Bf+tPyXNTANppcU+PyvvLYu281xF5PzfWsxUuoAOGUjQD"
    "iryFwBbJAp+UnVSrkZFZ8Wvm0HEzBkyiK7/eRpHAwfMUujZXEKXyXT18lsu0YF5Iz4qd8ESyZfX53n8p3q9mtu9D58ADD0PVuYQOUpaqLJ"
    "awpZx1xWxc5+4SETeqMpYeXFsmml8DWm+f0nNNZ4UfhrqsKqad4Avxajy+5GKW45J13wxTvJRBkCgYEAvtCJbOfJlbmMa61HTOAaAUOJ8o"
    "kHO+NxWG3UVnS+oRoMx4cdrNa0VWpNmN7GQMnbN8dl+Qxc8O2dnKwx5QpQt+o7fbqihaVR+NhNLsZi4pssEvn/84/tWPUmnyt/4ULRJr/l"
    "mACNSRR6r98sCjAb+S6LnEMVOmHqVJORsN5mBYUCgYEA9/EZxJ+7hevUHQdngt2wdvUiM5ZC836yXfbwa41ISz3YNyxadNIerwSYnNsNzL"
    "XRjjWXmgHiRjHAr0+4BSEKXN3qk9+YO8V4YRgUfJ1MtAOIP7fj3VwztMmV49A9Z+Rm6Gh3A9xBuX7HssIvq9JO4fr56/LINFPWsX4XUVOu"
    "tYkCgYBz0Ns4sM8YA5EJYhkevf7KuZWnEijD3t7TD4aMGzwBSHBtQsNuPrsiBO2oVb77YAmgp3RrX2eiDHdXuuRl4obvukn1nCw89gT1B0"
    "SBmYQ3inuL4RXLXZZwIgwZHCv4K7gKzvqp8dvPeZCl4s02OdEgw3GVnNnrn7a9MvyA39wIiQKBgDnSrKPCbMVKvmkWtPk8Ik9b0+IcBPks"
    "bwSi9mbeyCFkBuy3F1FvP2Cpvb23CHzZWknEDdsI3XBpYfqAqPXpQrVtu6tI1gP6hZx/NSfqt1y0Bi52AFo7ioN7D83VXry/84/37OmlkF"
    "5mRsRVrTBxF5x0H5z7Pd2WP9edBGsfDPuhAoGABrSkSha1UclD/3ClOAhnxMn4JdkDxX3rHkKuApnzPitVRwrz0yH4ttVxMQ0wj1i3rP2q"
    "L4V5cUh7nD0glwMwTeEzXW6hovIXagh9LjZfwLrjbgdGREEjvM8msB6zGAc1O+U2+OQJCbR3brW90ZXNyxOWjClOQDHKqH8XV4DBRpA=";
static unsigned char priKey[4096] = { 0, };
static int priKeySize = 0;

static int sample_setup() {
    EErrorCode result;

    result = wasdk_init();
    if (result != EEC_Success) {
        printf("[ERROR] %s\n", wasdk_error_message(result));
        return 1;
    }

    result = wasdk_base64_decoding(pubKey, &pubKeySize, sizeof(pubKey), testPubKey);
    if (result != EEC_Success) {
        printf("[ERROR] %s\n", wasdk_error_message(result));
        return 1;
    }

    result = wasdk_base64_decoding(priKey, &priKeySize, sizeof(priKey), testPriKey);
    if (result != EEC_Success) {
        printf("[ERROR] %s\n", wasdk_error_message(result));
        return 1;
    }

    return 0;
}

static int sample_wasdk_hybrid_encryption() {
    EErrorCode result;
    const unsigned char plaintext[] = { 'T','h','i','s',' ','i','s',' ','a',' ','t','e','s','t',' ','t','e','x','t' };
    int plaintextLen = sizeof(plaintext);
    unsigned char encrypted[512] = { 0, };
    int encryptedSize = 0;
    unsigned char decrypted[32] = { 0, };
    int decryptedSize = 0;

    printf("sample_wasdk_hybrid_encryption() => ");

    result = wasdk_hybrid_encrypt(encrypted, &encryptedSize, sizeof(encrypted), plaintext, plaintextLen,
            NULL, 0, ESA_SEED, ESOM_CBC, EHA_SHA256, pubKey, pubKeySize, ERES_OAEP_V21);
    if (result != EEC_Success) {
        printf("[ERROR] %s\n", wasdk_error_message(result));
        return 1;
    }

    result = wasdk_hybrid_decrypt(decrypted, &decryptedSize, sizeof(decrypted), NULL, NULL, 0, encrypted,
            encryptedSize, ESA_SEED, ESOM_CBC, EHA_SHA256, priKey, priKeySize, ERES_OAEP_V21);
    if (result != EEC_Success) {
        printf("[ERROR] %s\n", wasdk_error_message(result));
        return 1;
    }

    printf("[OK]\n");

    return 0;
}

int main() {
    int result;

    result = sample_setup();
    if (result != 0) {
        return result;
    }

    return sample_wasdk_hybrid_encryption();
}
