#include <stdio.h>

#include "wasdk_public.h"

static int sample_setup() {
    EErrorCode result = wasdk_init();
    if (result != EEC_Success) {
        printf("[ERROR] %s\n", wasdk_error_message(result));
        return 1;
    }
    return 0;
}

static int sample_wasdk_symmetric_encryption() {
    EErrorCode result;
    const unsigned char plaintext[] = { 'T','h','i','s',' ','i','s',' ','a',' ','t','e','s','t',' ','t','e','x','t' };
    unsigned char secretKey[] = {
        0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08,
        0x09, 0x0A, 0x0B, 0x0C, 0x0D, 0x0E, 0x0F, 0x10
    };
    unsigned char encrypted[16 * ((sizeof(plaintext) / 16) + 1)] = { 0, };
    int encryptedSize = 0;
    unsigned char decrypted[sizeof(encrypted)] = { 0, }; //  ũ ȣ ũ.  ũⰡ ƴ Ϳ  .
    int decryptedSize = 0;

    printf("sample_wasdk_symmetric_encryption() => ");
    
    result = wasdk_symmetric_encrypt(encrypted, &encryptedSize, sizeof(encrypted), plaintext, sizeof(plaintext),
            secretKey, 16, NULL, 0, ESA_SEED, ESOM_CBC);
    if (result != EEC_Success) {
        printf("[ERROR] %s\n", wasdk_error_message(result));
        return 1;
    }

    result = wasdk_symmetric_decrypt(decrypted, &decryptedSize, sizeof(decrypted), encrypted, encryptedSize,
            secretKey, 16, NULL, 0, ESA_SEED, ESOM_CBC);
    if (result != EEC_Success) {
        printf("[ERROR] %s\n", wasdk_error_message(result));
        return 1;
    }

    printf("[OK]\n");

    return 0;
}

int main() {
    int result;

    result = sample_setup();
    if (result != 0) {
        return result;
    }

    return sample_wasdk_symmetric_encryption();
}
